<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_advantage'))
{
    function sv_vc_advantage($attr,$content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'style'      => '',
            'color'      => 'info-yellow',
            'color2'     => '#f2d03b',
            'pos_info'   => 'info-left',
            'image'      => '',
            'title'      => '',
            'title2'     => '',
            'des'        => '',
            'label'      => esc_html__("More Info","megastore"),
            'link'       => '#',
        ),$attr));
        switch ($style) {
            case 'item-service15':
            case 'home-10':
                $html .=    '<div class="item-service10 '.esc_attr($style).'">
                                <div class="block">
                                    <div class="block-head">
                                        <div class="block-title">
                                            <div class="block-icon">
                                                '.wp_get_attachment_image($image,'full').'
                                            </div>
                                            <div class="block-text">
                                                <div class="block-title-text text-sm">'.esc_html($title2).'</div>
                                                <div class="block-title-text text-lg">'.esc_html($title).'</div>
                                            </div>
                                            <a href="'.esc_url($link).'" class="more-link"><span>'.$label.'</span></a>
                                        </div>
                                    </div>
                                </div>
                            </div>';
                break;

            case 'home-6-2':
                $html .=    '<div class="item-banner-adv6 half-banner '.esc_attr($pos_info).'">
                                <div class="banner-thumb"><a href="'.esc_url($link).'">'.wp_get_attachment_image($image,'full').'</a></div>
                                <div class="banner-info">
                                    <div class="inner-banner-info">
                                        <h2>'.esc_html($title).'</h2>
                                        <p>'.esc_html($des).'</p>
                                        <a href="'.esc_url($link).'" class="readmore"><i class="fa fa-arrow-circle-right" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>';
                break;

            case 'home-6':
                $html .=    '<div class="item-banner-adv6 full-banner">
                                <div class="banner-thumb"><a href="'.esc_url($link).'">'.wp_get_attachment_image($image,'full').'</a></div>
                                <div class="banner-info">
                                    <h3>'.esc_html($title2).'</h3>
                                    <h2>'.esc_html($title).'</h2>
                                    <p>'.esc_html($des).'</p>
                                    <a href="'.esc_url($link).'" class="readmore"><i class="fa fa-arrow-circle-down" aria-hidden="true"></i></a>
                                </div>
                            </div>';
                break;

            case 'service6':
                if(!empty($color2)) $color2 = SV_Assets::build_css('background:'.$color2.';');
                $html .=    '<div class="item-service '.esc_attr($color2).'">
                                <div class="service-icon">
                                    <a href="'.esc_url($link).'">'.wp_get_attachment_image($image,'full').'</a>
                                </div>
                                <div class="service-info">
                                    <div class="inner-service-info">
                                        <h2>'.esc_html($title).'</h2>
                                        <p>'.esc_html($des).'</p>
                                        <a href="'.esc_url($link).'" class="service-link"><i class="fa fa-plus" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>';
                break;

            case 'home-5':
                $html .=    '<div class="option5 item-adv '.esc_attr($pos_info.' '.$color).'">
                                <div class="adv-thumb">
                                    <a href="'.esc_url($link).'">'.wp_get_attachment_image($image,'full').'</a>
                                </div>
                                <div class="adv-info">
                                    <div class="inner-adv-info">
                                        <h2>'.esc_html($title).'</h2>
                                        <p>'.$des.'</p>
                                        <a href="'.esc_url($link).'" class="shopnow"><span>'.$label.'</span></a>
                                    </div>
                                </div>
                            </div>';
                break;
            
            default:
                if(!empty($image)){
                    $img = wp_get_attachment_image_src( $image ,"full");
                    $bg_class = SV_Assets::build_css('background: rgba(0, 0, 0, 0)  url("'.esc_url($img[0]).'") no-repeat scroll center top;');
                }
                $html .=    '<div class="option5 top-header5 '.esc_attr($bg_class).'">
                                <div class="container">
                                    <div class="inner-header5">
                                        <div class="adv-top-intro">
                                            <h2>'.esc_html($title).'</h2>
                                            <p>'.$des.'</p>
                                        </div>
                                        <a href="'.esc_url($link).'" class="link-adv-info">'.$label.'</a>
                                        <a href="'.esc_url($link).'" class="close-top-adv"><i class="fa fa-times" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>';
                break;
        }        
        return $html;
    }
}

stp_reg_shortcode('sv_advantage','sv_vc_advantage');

vc_map( array(
    "name"      => esc_html__("SV Advantage", 'megastore'),
    "base"      => "sv_advantage",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__("Style",'megastore'),
            "param_name"    => "style",
            "value"         => array(
                esc_html__("Top close button",'megastore')   => '',
                esc_html__("Home 5",'megastore')   => 'home-5',
                esc_html__("Service home 6",'megastore')   => 'service6',
                esc_html__("Home 6",'megastore')   => 'home-6',
                esc_html__("Home 6 (style 2)",'megastore')   => 'home-6-2',
                esc_html__("Home 10",'megastore')   => 'home-10',
                esc_html__("Home 15",'megastore')   => 'item-service15',
                )
        ),        
        array(
            "type" => "colorpicker",
            "heading" => esc_html__("Color",'megastore'),
            "param_name" => "color2",
            "dependency"    => array(
                "element"   => 'style',
                "value"     => 'service6',
                )
        ),
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__("Color",'megastore'),
            "param_name"    => "color",
            "value"         => array(
                esc_html__("Yellow",'megastore')   => 'info-yellow',
                esc_html__("Pink",'megastore')   => 'info-pink',
                esc_html__("Cyan",'megastore')   => 'info-cyan',
                esc_html__("Green",'megastore')   => 'info-green',
                ),
            "dependency"    => array(
                "element"   => 'style',
                "value"     => 'home-5',
                )
        ),
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__("Position Info",'megastore'),
            "param_name"    => "pos_info",
            "value"         => array(
                esc_html__("Left",'megastore')   => 'info-left',
                esc_html__("Right",'megastore')   => 'info-right',
                ),
            "dependency"    => array(
                "element"   => 'style',
                "value"     => array('home-5','home-6-2'),
                )
        ),
        array(
            "type" => "attach_image",
            "heading" => esc_html__("Image",'megastore'),
            "param_name" => "image",
        ),
        array(
            "type" => "textfield",
            "holder"    => 'h5',
            "heading" => esc_html__("Pretext Title",'megastore'),
            "param_name" => "title2",
            "dependency"    => array(
                "element"   => 'style',
                "value"     => array('home-6','home-10','item-service15'),
                )
        ),
        array(
            "type" => "textfield",
            "holder"    => 'h4',
            "heading" => esc_html__("Title",'megastore'),
            "param_name" => "title",
        ),
        array(
            "type" => "textfield",
            "holder"    => 'p',
            "heading" => esc_html__("Description",'megastore'),
            "param_name" => "des",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Label Button",'megastore'),
            "param_name" => "label",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Link",'megastore'),
            "param_name" => "link",
        ),
    )
));