<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
if(!class_exists('SV_MetaController'))
{
    class SV_MetaController
    {
        static function _init()
        {
            add_action('admin_init', array(__CLASS__,'sv_custom_meta_boxes'));
        }
        static function sv_custom_meta_boxes(){
            //Format content
            $format_metabox = array(
                'id' => 'block_format_content',
                'title' => esc_html__('Format Settings', 'megastore'),
                'desc' => '',
                'pages' => array('post'),
                'context' => 'normal',
                'priority' => 'high',
                'fields' => array(                
                    array(
                        'id' => 'format_image',
                        'label' => esc_html__('Upload Image', 'megastore'),
                        'type' => 'upload',
                    ),
                    array(
                        'id' => 'format_gallery',
                        'label' => esc_html__('Add Gallery', 'megastore'),
                        'type' => 'Gallery',
                    ),
                    array(
                        'id' => 'format_media',
                        'label' => esc_html__('Link Media', 'megastore'),
                        'type' => 'text',
                    )
                ),
            );
            // SideBar
        	$sidebar_metabox_default = array(
                'id'        => 'sv_sidebar_option',
                'title'     => 'Advanced Settings',
                'desc'      => '',
                'pages'     => array( 'page','post','product'),
                'context'   => 'side',
                'priority'  => 'low',
                'fields'    => array(
                    array(
                        'id'          => 'sv_sidebar_position',
                        'label'       => esc_html__('Sidebar position ','megastore'),
                        'type'        => 'select',
                        'std' => '',
                        'choices'     => array(
                            array(
                                'label'=>esc_html__('--Select--','megastore'),
                                'value'=>'',
                            ),
                            array(
                                'label'=>esc_html__('No Sidebar','megastore'),
                                'value'=>'no'
                            ),
                            array(
                                'label'=>esc_html__('Left sidebar','megastore'),
                                'value'=>'left'
                            ),
                            array(
                                'label'=>esc_html__('Right sidebar','megastore'),
                                'value'=>'right'
                            ),
                        ),

                    ),
                    array(
                        'id'        =>'sv_select_sidebar',
                        'label'     =>esc_html__('Selects sidebar','megastore'),
                        'type'      =>'sidebar-select',
                        'condition' => 'sv_sidebar_position:not(no),sv_sidebar_position:not()',
                    ),
                    array(
                        'id'          => 'sv_show_breadrumb',
                        'label'       => esc_html__('Show Breadcrumb','megastore'),
                        'type'        => 'select',
                        'choices'     => array(
                            array(
                                'label'=>esc_html__('--Select--','megastore'),
                                'value'=>'',
                            ),
                            array(
                                'label'=>esc_html__('Yes','megastore'),
                                'value'=>'yes'
                            ),
                            array(
                                'label'=>esc_html__('No','megastore'),
                                'value'=>'no'
                            ),
                        ),

                    ),
                    array(
                        'id'          => 'sv_header_page',
                        'label'       => esc_html__('Choose page header','megastore'),
                        'type'        => 'select',
                        'choices'     => sv_list_header_page()
                    ),
                    array(
                        'id'          => 'sv_footer_page',
                        'label'       => esc_html__('Choose page footer','megastore'),
                        'type'        => 'page-select'
                    ),
                    array(
                        'id' => 'body_bg',
                        'label' => esc_html__('Body background', 'megastore'),
                        'type' => 'colorpicker',
                    ),
                    array(
                        'id' => 'page_box',
                        'label' => esc_html__('Box Shadow', 'megastore'),
                        'type' => 'on-off',
                        'std'   => 'off',
                    ),
                )
            );
            $product_custom_tab = array(
                'id' => 'block_product_custom_tab',
                'title' => esc_html__('Product Display', 'megastore'),
                'desc' => '',
                'pages' => array('product'),
                'context' => 'normal',
                'priority' => 'low',
                'fields' => array(
                    array(
                        'id'          => 'product_tab_data',
                        'label'       => esc_html__('Custom Tab','megastore'),
                        'type'        => 'list-item',
                        'settings'    => array(
                            array(
                                'id' => 'tab_content',
                                'label' => esc_html__('Content', 'megastore'),
                                'type' => 'textarea',
                            ),
                        )
                    ),
                    array(
                        'id'          => 'attribute_style',
                        'label'       => esc_html__('Attribute Style','megastore'),
                        'type'        => 'select',
                        'choices'     => array(
                            array(
                                'value'=> 'normal',
                                'label'=> esc_html__("Normal", 'megastore'),
                            ),
                            array(
                                'value'=> 'special',
                                'label'=> esc_html__("Special", 'megastore'),
                            ),
                        )
                    ),
                    array(
                        'id'          => 'show_single_number',
                        'label'       => esc_html__('Show Single Products Number','megastore'),
                        'type'        => 'text',
                    ),
                    array(
                        'id'          => 'show_single_lastest',
                        'label'       => esc_html__('Show Single Latest Products','megastore'),
                        'type'        => 'select',
                        'choices'     => array(
                            array(
                                'value'=> '',
                                'label'=> esc_html__("--Select--", 'megastore'),
                            ),
                            array(
                                'value'=> 'on',
                                'label'=> esc_html__("Yes", 'megastore'),
                            ),
                            array(
                                'value'=> 'off',
                                'label'=> esc_html__("No", 'megastore'),
                            ),
                        )
                    ),
                    array(
                        'id'          => 'show_single_upsell',
                        'label'       => esc_html__('Show Single Upsell Products','megastore'),
                        'type'        => 'select',
                        'choices'     => array(
                            array(
                                'value'=> '',
                                'label'=> esc_html__("Default", 'megastore'),
                            ),
                            array(
                                'value'=> 'on',
                                'label'=> esc_html__("Yes", 'megastore'),
                            ),
                            array(
                                'value'=> 'off',
                                'label'=> esc_html__("No", 'megastore'),
                            ),
                        )
                    ),
                    array(
                        'id'          => 'show_single_relate',
                        'label'       => esc_html__('Show Single Relate Products','megastore'),
                        'type'        => 'select',
                        'choices'     => array(
                            array(
                                'value'=> '',
                                'label'=> esc_html__("Default", 'megastore'),
                            ),
                            array(
                                'value'=> 'on',
                                'label'=> esc_html__("Yes", 'megastore'),
                            ),
                            array(
                                'value'=> 'off',
                                'label'=> esc_html__("No", 'megastore'),
                            ),
                        )
                    ),
                ),
            );
            //Show page title
            $show_page_title = array(
                'id' => 'page_title_setting',
                'title' => esc_html__('Title page setting', 'megastore'),
                'pages' => array('page'),
                'context' => 'normal',
                'priority' => 'high',
                'fields' => array(
                    array(
                        'id' => 'show_title_page',
                        'label' => esc_html__('Show title', 'megastore'),
                        'type' => 'on-off',
                        'std'   => 'on',
                    ),
                    array(
                        'id'          => 'main_color',
                        'label'       => esc_html__('Main color','megastore'),
                        'type'        => 'colorpicker',
                    ),
                    array(
                        'id'          => 'main_color2',
                        'label'       => esc_html__('Main color 2','megastore'),
                        'type'        => 'colorpicker',
                    ),
                    array(
                        'id'          => 'price_color',
                        'label'       => esc_html__('Price color','megastore'),
                        'type'        => 'colorpicker',
                    ),
                ),
            );
            $product_trendding = array(
                'id' => 'product_trendding',
                'title' => esc_html__('Product Type', 'megastore'),
                'desc' => '',
                'pages' => array('product'),
                'context' => 'side',
                'priority' => 'high',
                'fields' => array(                
                    array(
                        'id'    => 'trending_product',
                        'label' => esc_html__('Product Trendding', 'megastore'),
                        'type'        => 'on-off',
                        'std'         => 'off'
                    ),
                ),
            );
            if (function_exists('ot_register_meta_box')){
                ot_register_meta_box($format_metabox);
                ot_register_meta_box($sidebar_metabox_default);
                ot_register_meta_box($product_custom_tab);
                ot_register_meta_box($show_page_title);
                ot_register_meta_box($product_trendding);
            }
        }
    }
    SV_MetaController::_init();
}
?>