<?php
App::uses('AppHelper', 'View/Helper');
class LeowebHelper extends Helper {
	public $helpers = array('Html','Form','Text');
	
	public function meta() {
        $data = '';
		$meta = ( isset($this->_View->viewVars['meta']) ? $this->_View->viewVars['meta']: array() );
			
		foreach($meta as $key=>$value) {
			if(!empty($value))
				$data .= "\n\t".$this->Html->meta($key,$value);
		}
		$data .= "\n\t".'<meta name="author" content="Mahmood Dehghani - imahmood.ir" />';
		$data .= "\n\t".'<meta name="robots" content="index,follow" />'."\n\n\t";
		return $data;
	}
    
    public function ie($fileName = null, $ver = '6') {
    	if( !empty($fileName) ){
			$data = "\t<!--[if IE $ver]>";
	    	$data .= $this->Html->css($fileName);
			$data .= "<![endif]-->\n";
	    	return $data;
    	}
    }

	
	public function truncate($text = null) {
		if(!empty($text)) {
			return $this->Text->truncate($text,Configure::read('ShortContentLength'),
								  array('ending' => '...','exact' => false,'html' => true)
								  );
		}
	}
	
	public function gravatar($email = null, $options = array() ) {
		$url = 'http://www.gravatar.com/avatar/';
		$url .= md5($email);
		
		if( !empty($options) ) {			
			foreach($options as $key => $value) {
				$params[] = $key . '=' . $value;
			}
			$url .= '/?' . implode('&',$params);
		}
		
		return $this->Html->image($url);
	}
}
?>
