<?php
App::uses('AppModel', 'Model');

class File extends AppModel {
	public $displayField = 'filename';
    private $filename;

    public $validate = array(
		'filename' => array(
			'rule' => array('notempty'),
			'message' => 'فایل انتخاب نشده است.',
		),
		'filedesc' => array(
			'rule' => array('notempty'),
			'message' => 'توضیحات فایل را وارد کنید.',
		),
		'name' => array(
			'rule' => array('notempty'),
			'message' => 'نام خود را وارد کنید.',
		),
		'email' => array(
			'rule' => array('email'),
			'message' => 'آدرس ایمیل خود را وارد کنید.',
		),
	);
    
	public function beforeDelete() {
		$this->filename = $this->find('first', array(
										'conditions' => array('File.id' => $this->id),
										'fields' => 'File.filename'
									));
        $this->filename = $this->filename['File']['filename'];
		return true;
	}
	
	public function afterDelete() {
		if( !empty($this->filename) ) {            
            $path = APP .'downloads' . DS . $this->filename;
            if(file_exists($path)) {
                unlink($path);
			}
		}
		return true;
	}
    
}