<?php
App::uses('AppController', 'Controller');

class FilesController extends AppController {
	public $components = array('Lwupload');
	public $helpers = array('Number');
    
    public function beforeFilter() {
        parent::beforeFilter();
    }
    
    public function index() {
        $this->set('title_for_layout', Configure::read('SiteName'));
        
        $this->Lwupload->fileSuffix = true;
        $this->Lwupload->uploadPath = APP .'downloads';
        $this->Lwupload->fileExtensions = array('mp3','wma','wmv','mp4','avi','mkv','flv','3gp','rar','zip');
        
        
        if( !empty($this->request->data) ) {
            $file_info = $this->Lwupload->upload($this->request->data['File']['filename']);
            
			if( $file_info ) {
                $ajax['success'] = true;
				$ajax['filename'] = $file_info['name'];
				
				$this->request->data['File']['filename'] = $file_info['name'];
                $this->request->data['File']['filemask'] = $file_info['mask'];
                $this->request->data['File']['filemime'] = $file_info['mime'];
                $this->request->data['File']['download_id'] = String::uuid();
                
				$this->File->create();
				if(!$this->File->save($this->request->data)) {
					$this->deleteFile( APP .'downloads' . DS . $file_info['name'] );
					$ajax['success'] = false;
				}else{
                    
                    // Send Admin Notification
                    $this->sendMail(array_merge($this->request->data,array(
                                        'to' => Configure::read('SiteEmail'),
                                        'subject' => 'فایل جدید',
                                        'template' => 'notify',
                                    )));
                }
				
			}else{
                $ajax['success'] = false;
            }
            
            $this->ajaxResponse($ajax);
        }
        
        $this->set('maxUploadSize', $this->Lwupload->getMaxUploadSize());
    }

    public function admin_index() {
        $this->set('title_for_layout', 'مدیریت فایل‌ها');
        
		$this->paginate = array(
				'limit' => 10,
				'order' => array('File.created' => 'desc')
		);
		$this->File->recursive = 0;
		$this->set('files', $this->paginate());
    }
    
	public function download($down_id = null, $mask = null) {
        $file = $this->File->find('first', array(
							'conditions' => array('File.download_id' => $down_id, 'File.filemask' => $mask),
							'fields' => array('File.filename','File.filemask')
						));
		
		if( !empty($file) ) {
            $this->autoLayout = false;
			$this->viewClass = 'Media';
			
            $temp = explode('.', $file['File']['filemask']);
			
            $ext = array_pop($temp);
            $name = implode('.', $temp);
            
			$params = array(
					'id' => $file['File']['filename'],
					'name' => $name,
					'extension' => $ext,
					'download' => true,
					'path' => APP .'downloads' . DS,
				);
			$this->set($params);
		}else{
			$this->set('title_for_layout', 'دریافت فایل');
			$this->layout = 'download';
            
			$this->setFlash('فایل مورد نظر پیدا نشد.');
		}
	}
    
    public function admin_delete($id = null) {
		$this->File->id = $id;
		if (!$this->File->exists()) {
			throw new NotFoundException('رکورد مورد نظر پیدا نشد.');
		}
        
		if($this->File->delete()) {
            $this->setFlash('فایل مورد نظر با موفقیت حذف شد.', 'success');
            $this->redirect(array('action' => 'index'));
            
		}else{
			$this->setFlash('خطا در حذف فایل. لطفا مجددا سعی کنید.', 'fail');
		}
    }


    private function deleteFile($path = null) {
		if( !empty($path) ) {
			if(file_exists($path)) {
				return unlink($path);
			}
		}
		return false;
	}
}