<?php
 /*
  * Author  : Mahmood Dehghani
  * email   : mahmood.public@gmil.com
  * Copyright © 2012  -  imahmood.ir   All Rights Reserved.
  */
class LwuploadComponent extends Component {
	public $uploadPath;
    public $fileExtensions;
    public $fileSuffix = false;
	private $error = '';
	
	public function upload($file) {	
		if($file['error'] != 4) {
			if( $this->fileSize($file['size']) && $this->checkExt($file['name']) ) {
				
				$filename = $this->fileName($file['name']);
				
				if( is_uploaded_file($file['tmp_name']) && move_uploaded_file($file['tmp_name'],$this->uploadPath.'/'.$filename['name']) ){
                    return array(
								'name' => $filename['name'],
								'mask' => $filename['mask'],
								'mime' => $file['type'],
							);
				}else{
					$this->error = 'Upload Error.';
				}
			}
		}
		return false;
	}
	
	public function getMaxUploadSize() {
		return min(
                $this->_letToNum(ini_get('post_max_size')),
                $this->_letToNum(ini_get('upload_max_filesize')),
                $this->_letToNum(Configure::read('UploadSize').'M')
               );
	}
	
	private function fileSize($size) {		
		if( ($size>0) && ($size<=$this->getMaxUploadSize()) )
			return true;
		
		$this->error ='size error.';
		return false;
	}
    
    private function checkExt($filename = null) {
        $ext = end( explode('.', $filename) );
        
        if(in_array($ext, $this->fileExtensions) ) {
            return true;
        }
        $this->error = 'ext error.';
        return false;
    }


    private function fileName($name) {
		$characters = array('~','!','@','#','$','%','^','&','*','(',')','=','+','\\','|','/','[',']','{','}','\'',',',';',':',' ');
		$data['name'] = $data['mask'] = strtolower( str_replace($characters, '_', $name) );
		
		if($this->fileSuffix) {
			$data['name'] .= '.' . md5($data['name'].String::uuid());
			
		}else{
			while( file_exists($this->uploadPath.'/'.$data['name']) ){
				$data['name'] = rand(10000,99999).'_'.$data['mask'];
			}
			$data['mask'] = $name['name'];
		}
		
		return $data;
    }
    
    private function _letToNum($v){
	    $l = substr($v, -1);
	    $ret = substr($v, 0, -1);
	    switch(strtoupper($l)){
			case 'P':
				$ret *= 1024;
			case 'T':
				$ret *= 1024;
			case 'G':
				$ret *= 1024;
			case 'M':
				$ret *= 1024;
			case 'K':
				$ret *= 1024;
				break;
	    }
	    return $ret;
	}

}
?>
