<?php
App::uses('Controller', 'Controller');
App::uses('CakeEmail', 'Network/Email');

class AppController extends Controller {
    public $components = array('Auth','Session');
    public $helpers  = array('Html','Form','Session','Leoweb');
    
    public function beforeFilter() {
        // Auth component
        $this->Auth->loginRedirect = array('controller'=>'files','action'=>'index');
        $this->Auth->authError = 'برای ورود به مدیریت، نام کاربری و رمز عبور خود را وارد کنید.';
        $this->Auth->flash['element'] = 'flash';
        $this->Auth->flash['params']['class'] = 'fail';
        $this->Auth->allow('index','view','add','download');
        
        // Get settins
        $settings = ClassRegistry::init('Setting')->find('all');
        foreach($settings as $setting) {
            Configure::write($setting['Setting']['name'],$setting['Setting']['value']);
        }
        
        // Set view params
        $this->set( array(
                    'siteName' => Configure::read('SiteName'),
                    'message' => Configure::read('Message'),
                    'copyright' => Configure::read('Copyright'),
                ));
        
        // Theme
        $this->viewClass = 'Theme';
        if( $this->isAdmin() ) {
            $this->theme = 'Admin';
        }  else {
            $this->theme = 'Default';
        }
    }
    
    public function isAdmin() {
        if( isset($this->request->params['prefix']) && $this->request->params['admin'] == 1 ) {
			return true;
        }
        return false;
    }
    
    public function setFlash($message,$class = '') {
        $this->Session->setFlash($message, 'flash', array('class'=>$class) );
    }
    
	public function beforeRender() {
		if ($this->name == 'CakeError') {
			$this->layout = 'error';
		}
	}
    
    public function ajaxResponse( $res = array() ) {
        if( !empty($res) && $this->request->is('ajax')) {
            $this->autoRender = false;
            
            $this->response->disableCache();
            $this->response->type('application/json');
            $this->response->body( json_encode($res) );
        }
        return;
    }
    
    public function sendMail($data = null) {
        if( !empty($data) ) {
            $email = new CakeEmail();
            $email->from( array(Configure::read('SiteEmail')=>Configure::read('SiteName')) )
                ->to($data['to'])
                ->subject($data['subject'])
                ->replyTo(Configure::read('SiteEmail'))
                
                ->template($data['template'], 'email')
                ->emailFormat('html')
                
                ->viewVars(array('data'=>$data));
                
            if($email->send())
                return true;
        }
        return false;
    }
    
}
?>