$(document).ready(function(){

    $('#word-filter').DataTable( {
        "processing": true,
        "serverSide": true,
        "ajax": $('#word-filter').data('ajax-url')
    } );

    $(document).on('click', '.remove-filter-word', remove);
    $(document).on('click', '#add', add);
});

var add = function(){
    var $submitButton = $(this);
    var url = $submitButton.parents('form').attr('action');

    $submitButton.ajaxHandler(url, {
        data : $submitButton.parents('form').serialize(),
        success : function(response){
            if(response.status){
                /* Tags Input Clear */
                $('.input-tags').importTags('');
                swal("Added!", response.message, "success");
                window.location.href = response.url;
            }else{
                swal("Warning!", response.message.join("\r\n"), "error");
            }
        }
    })
    return false;
};

var remove = function(){

    var $removeBtn = $(this);

    swal({
        title: "Warning",
        text: "Are you sure?",
        type: "warning",
        showCancelButton: true,
        cancelButtonText: "Cancel",
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, delete it!",
        closeOnConfirm: false }, function(){

        var url = $removeBtn.attr('href');

        $removeBtn.ajaxHandler(url, {
            success : function(response){
                if(response.status){
                    $removeBtn.parents('tr').fadeOut(function(){
                        $(this).remove();
                    });
                    swal("OK!", response.message, "success");
                }else{
                    swal("Warning!", response.message, "error");
                }
            }
        })
    });

    return false;
};