$(document).ready(function(){

    $('#reports').DataTable( {
        "processing": true,
        "serverSide": true,
        "ajax": $('#reports').data('ajax-url')
    } );

    $(document).on('click', '.remove-report', remove);
});

var remove = function(){

    var $removeBtn = $(this);

    swal({
        title: "Warning",
        text: "Are you sure?",
        type: "warning",
        showCancelButton: true,
        cancelButtonText: "Cancel",
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, delete it!",
        closeOnConfirm: false }, function(){

        var url = $removeBtn.attr('href');

        $removeBtn.ajaxHandler(url, {
            success : function(response){
                if(response.status){
                    $removeBtn.parents('tr').fadeOut(function(){
                        $(this).remove();
                    });
                    swal("OK!", response.message, "success");
                }else{
                    swal("Warning!", response.message, "error");
                }
            }
        })
    });

    return false;
};