$(document).ready(function() {

    // Image Upload
    $.each($('.image-upload'), function(){
        var $uploadElement = $(this);
        $uploadElement.uploadFile({
            url : $uploadElement.attr('href'),
            fileName : 'image',
            dragDrop : false,
            multiple : false,
            /*maxFileCount : 1,*/
            maxFileSize : 2000*1024,
            allowedTypes : 'jpg,png,gif',
            showAbort : false,
            showDone : false,
            showProgress : true,
            showFileCounter : false,
            formData: {
                image_type : $uploadElement.attr('data-type')
            },
            onSuccess : function(files, response, xhr, pd) {
                if(response.success){
                    swal("Updated!", response.message, "success");
                    pd.statusbar.hide();
                    $uploadElement.parents('.upload-div').find('.image').attr("src", response.image);
                } else {
                    swal("Warning!", response.message.join("\r\n"), "error");
                }
            }
        });
    });

    // File Upload
    $.each($('.file-upload'), function(){
        var $uploadElement = $(this);
        $uploadElement.uploadFile({
            url : $uploadElement.attr('href'),
            fileName : 'file',
            dragDrop : false,
            multiple : false,
            /*maxFileCount : 1,*/
            maxFileSize : 2000*1024,
            showAbort : false,
            showDone : false,
            showProgress : true,
            showFileCounter : false,
            formData: {
                file_type : $uploadElement.attr('data-type')
            },
            onSuccess : function(files, response, xhr, pd) {
                if(response.success){
                    swal("Updated!", response.message, "success");
                    pd.statusbar.hide();
                } else {
                    swal("Warning!", response.message.join("\r\n"), "error");
                }
            }
        });
    });

});
