(function($) {
    $.fn.ajaxHandler = function (url, options) {

        var defaults = {
            method: 'POST',
            dataType: 'json',
            data: '',
            loader: true,
            before: function(){},
            after: function(){},
            success: function(){},
            error: function(){}
        };

        var $element   = $(this);
        var settings = $.extend({}, defaults, options);

        var ajaxHandler = function(){

            if(getRequestStatus()) {
                console.log('Daha önceki istek devam ediyor');
                return false;
            }

            var text = $element.text();
            var request = $.ajax({
                type : settings.method,
                url : url,
                headers: settings.headers,
                dataType : settings.dataType,
                data : settings.data,
                beforeSend : function(){
                    lockRequest();
                    if(settings.loader === true) openLoader();
                    settings.before();
                    $element.text('PLEASE WAIT..');
                    $element.attr('disabled', 'disabled');
                },
                success : function(response){
                    console.log(response);
                    settings.success(response);
                },
                error : function(e){
                    console.log('Hata oluştu',e);
                    settings.error();
                },
                complete : function(){
                    settings.after();
                    unlockRequest();
                    if(settings.loader === true) closeLoader();
                    $element.text(text);
                    $element.removeAttr('disabled');
                }
            });

            return request;
        };

        var lockRequest = function(){
            $element.addClass('ajax-process');

        };
        var unlockRequest = function(){
            $element.removeClass('ajax-process');
        };
        var getRequestStatus = function(){
            if($element.hasClass('ajax-process'))
                return true;
            return false;
        };

        var openLoader = function(){

        };

        var closeLoader = function(){

        };

        return ajaxHandler();

    };
}( jQuery ));