@extends('layouts.master')

@section('metas')
    <title>Website found in {{ $country['name'] }} - {{ $settings->site_name }}</title>
    <meta name="description" content="{{ standard_number($country['website_count']) }} websites found in {{ $country['name'] }}..."/>
    <meta name="keywords" content="{{ $country['name'] }}, {{ $country['name'] }} websites"/>
@stop

@section('content')

    <div class="container">
        <ol class="breadcrumb">
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="{{ route('index') }}" itemprop="url"><span itemprop="title">@language('home')</span></a></li>
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb" itemprop="child"><a href="{{ route('site.country') }}" itemprop="url"><span itemprop="title">@language('countries')</span></a></li>
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb" itemprop="child" class="active"><a href="{{ route('site.country-websites', [$country['slug']]) }}" itemprop="url"><span itemprop="title">{{ $country['name'] }}</span></a></li>
        </ol>
    </div>

    <!-- Start Content -->
    <div class="container content">

        <!-- Start Content Sol -->
        <div class="content-sol col-md-8">

            <div class="main-ads">
                @if ($settings->ads_ap_header_status == 1)
                    {{ $settings->ads_ap_header_code }}
                @endif
            </div>

            <h1 class="st-h1"><img src="{{ asset('img/flags2/'. $country['alpha_2'] .'.png') }}" alt="img" class="flag">@language('country_website_list_title', ['country' => $country['name']])
                <span>({{ standard_number($country['website_count']) }})</span></h1>
            @if($sites)
                @foreach($sites as $site)

                <div class="list-get">
                    <h1><a href="{{ route('site.name', [$site['name']]) }}"><img src="{{ 'http://s2.googleusercontent.com/s2/favicons?domain_url=' . $site['name'] }}" class="favicon"/>{{ Str::title(censor($site['name'])) }}</a></h1>
                    <h4>{{{ Str::limit(censor($site['site_title'])) }}}</h4>
                    <p>{{{ Str::limit(censor($site['site_description']), 250) }}}</p>

                    @if($site['google_rank'] >= 0)
                        <span class="pagerank">Pagerank<b>{{ $site['google_rank'] }}</b></span>
                    @else
                        <span class="pagerank">Pagerank<b>n/a</b></span>
                    @endif

                    @if($site['alexa_rank'] > 0)
                        <span class="alexa-rank">{{ standard_number($site['alexa_rank']) }}</span>
                    @else
                        <span class="alexa-rank">n/a</span>
                    @endif


                </div>

                @endforeach
            @endif

            {{ $sites->links('layouts.paginator') }}

        </div>
        <!-- End Content Sol -->

        @include('layouts.partials.sidebar.general')

    </div>
    <!-- End Content -->

@stop