<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Css Files -->
    <link href="{{ asset('css/reset.css') }}" rel="stylesheet">
    <link href="{{ asset('css/bootstrap.css') }}" rel="stylesheet">


</head>

<body>
Bugünlük unique : <strong>{{ $unique }}</strong> <br>
Bugün eklenen site : <strong>{{ $todayWebsiteCount }}</strong>
<div class="table-responsive">
    <table class="table table-bordered">
        <thead>
            <tr>
                <th><strong>??</strong></th>
                <th width="70"><strong>Time</strong></th>
                <th><strong>Path</strong></th>
                <th><strong>Co</strong></th>
                <th><strong>Region</strong></th>
                <th><strong>ISP</strong></th>
                <th><strong>IP Address</strong></th>
                <th><strong>Referer</strong></th>
                <th><strong>User Agent</strong></th>
            </tr>
        </thead>
        <tbody>
        @foreach($stats as $stat)
            <tr>
                <td>@if($stat->human)<img src="{{ asset('img/true-icon.png') }}"/>@else <img src="{{ asset('img/false-icon.png') }}"/>@endif</td>
                <td>{{ date('H:i', $stat->visit_time) }}</td>
                <td>{{ Str::limit($stat->path, 30) }}</td>
                <td>@if($stat->country_code)<img src="{{ asset('img/flags2/'. Str::lower($stat->country_code) .'.png') }}" title="{{ $stat->country }}" />@else - @endif</td>
                <td>@if($stat->region){{ $stat->region }}@else - @endif</td>
                <td>@if($stat->isp){{ $stat->isp }}@else - @endif</td>
                <td>{{ $stat->ip_address }} <a href="http://www.ip-tracker.org/locator/ip-lookup.php?ip={{ $stat->ip_address }}" target="_blank">[trace]</a></td>
                <td>@if($stat->referer){{ Str::limit($stat->referer, 50) }}@else - @endif</td>
                <td title="{{ $stat->user_agent }}">{{ Str::limit($stat->user_agent, 50) }}</td>
            </tr>
        @endforeach
        </tbody>
    </table>
</div>

</body>
</html>
