@extends('layouts.master')

@section('metas')
    <title>Report - {{ $settings->site_name }}</title>
    <meta name="description" content="Page to report inappropriate content on {{ $settings->site_name }}"/>
    <meta name="keywords" content="report, complaint form, website report"/>
@stop

@section('scripts')
    <script type="text/javascript" src='http://www.google.com/recaptcha/api.js'></script>
    <script type="text/javascript" src="{{ asset('js/contact.js') }}"></script>
@stop

@section('content')

    <div class="container">
        <ol class="breadcrumb">
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="{{ route('index') }}" itemprop="url"><span itemprop="title">Anasayfa</span></a></li>
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb" itemprop="child" class="active"><a href="{{ route('site.report') }}" itemprop="url"><span itemprop="title">Report</span></a></li>
        </ol>
    </div>

    <!-- Start Content -->
    <div class="container content">

        <!-- Start Content Sol -->
        <div class="content-sol col-md-8">

            <div class="main-ads">
                <img src="{{ asset('img/728x90.png') }}" alt="img" style="width:100%;">
            </div>

            <h1 class="st-h1">@language('report_title')</h1>
            <p class="padding-t-10 main-p">
                @language('report_desc')
            </p>
            <!-- START FORM -->
            <div class="post-form margin-t-30">
                <h2>@language('report_form')</h2>
                <form action="{{ route('ajax.report') }}">
                    <input type="text" name="url" class="form-control stinput" value="{{ $name }}" disabled>
                    <input type="hidden" name="id" value="{{ $id }}">
                    <input type="text" name="email" class="form-control stinput" placeholder="@language('email')">
                    <select name="subject" class="form-control stselect">
                        <option value="">@language('choose_a_report_subject')</option>
                        <option value="This page contains adult or pornographic content.">@language('adult_or_pornographic_content')</option>
                        <option value="This page contains violent content.">@language('contains_violent_content')</option>
                        <option value="This page violates AdSense policies.">@language('violate_adsense_program_policies')</option>
                    </select>
                    <textarea name="message" class="form-control stinput" rows="5" placeholder="@language('additional_information')"></textarea>

                    <div class="g-recaptcha" data-sitekey="{{ $settings->api_google_recaptcha_site_key }}"></div>

                    <div class="clear"></div>

                    <button id="send-me" type="submit" class="button" data-text="@language('send_form')" data-loading-text="@language('please_wait')">@language('send_form')</button>

                </form>
            </div>
            <!-- END FORM -->

        </div>
        <!-- End Content Sol -->

        @include('layouts.partials.sidebar.general')

    </div>
    <!-- End Content -->

@stop