@extends('layouts.master')

@section('scripts')
    <script type="text/javascript" src="{{ asset('js/remove.js') }}"></script>
@stop

@section('content')

    <div class="container">
        <ol class="breadcrumb">
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="{{ route('index') }}" itemprop="url"><span itemprop="title">@language('home')</span></a></li>
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb" itemprop="child" class="active"><a href="{{ route('site.remove') }}" itemprop="url"><span itemprop="title">@language('remove_website')</span></a></li>
        </ol>
    </div>
    <!-- Start Content -->
    <div class="container content">

        <!-- Start Content Sol -->
        <div class="content-sol col-md-8">

            <div class="main-ads">
                <img src="{{ asset('img/728x90.png') }}" alt="img" style="width:100%;">
            </div>

            <h1 class="st-h1">@language('remove_website_button')</h1>

            <p class="padding-t-10 main-p"></p>

            <form action="{{ route('ajax.verify-website', [$url]) }}">
                <label>@language('verification_nethod') :
                    <select id="verification-method" name="verification-method" class="form-control" style="width:160px; display:inline; margin-left:5px;">
                        <option value="file-upload">@language('upload_file')</option>
                        <option value="html-code">@language('html_code')</option>
                    </select>
                </label>

                <div id="file-upload" class="verification-methods">
                    <div class="dotted-div">
						<p><h4><b>@language('instructions')</b></h4></p>
                        <ul>
                            <li>@language('upload_file_step_1') <a href="{{ route('site.download-verification-file', [$url]) }}" target="_blank">@language('download')</a></li>
                            <li>@language('upload_file_step_2', ['url' => $url])</li>
                            <li><a href="{{ 'http://' . $url . '/' . $removeCode . '.html' }}" target="_blank">@language('upload_file_step_3')</a></li>
                            <li>@language('upload_file_step_4')</li>
                        </ul>
                    </div>

                </div>

                <div id="html-code"  class="verification-methods" style="display: none;">
                    <div class="dotted-div">

                        <p><h4><b>@language('instructions')</b></h4></p>
                        <p>1. @language('html_code_step_1')</p>
                        <p><span class="mark-green">{{{ '<meta name="aws-verify" content="aws-' . $removeCode . '"/>' }}}</span></p>
                        <p>2. @language('html_code_step_2')</p>
                        <p><strong>@language('example'):</strong></p>
                        <p><img src="{{ asset('img/code.png') }}" alt="code"></p>

                    </div>
                </div>

                <button id="start-verification" type="submit" class="button" data-text="@language('verify')" data-loading-text="@language('please_wait')">@language('verify')</button>
            </form>

        </div>
        <!-- End Content Sol -->

        @include('layouts.partials.sidebar.general')

    </div>
    <!-- End Content -->


@stop