@extends('layouts.master')

@section('metas')
    <title>{{ Str::title($page->title[$currentLanguage['short']]) }} - {{ $settings->site_name }}</title>
@stop

@section('content')

    <div class="container">
        <ol class="breadcrumb">
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="{{ route('index') }}" itemprop="url"><span itemprop="title">@language('home')</span></a></li>
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb" itemprop="child" class="active"><a href="{{ route('site.page', [$page->slug]) }}" itemprop="url"><span itemprop="title">{{ Str::title($page->page_title[$currentLanguage['short']]) }}</span></a></li>
        </ol>
    </div>

    <!-- Start Content -->
    <div class="container content text-content">

        <!-- Start Content Sol -->
        <div class="content-sol col-md-8">

            <div class="main-ads">
                @if ($settings->ads_ap_header_status == 1)
                    {{ $settings->ads_ap_header_code }}
                @endif
            </div>

            <h1 class="st-h1">{{ $page->page_title[$currentLanguage['short']] }}</h1>

            {{ $page->content[$currentLanguage['short']] }}

        </div>
        <!-- End Content Sol -->

        @include('layouts.partials.sidebar.general')

    </div>
    <!-- End Content -->

@stop