<!-- Start Contnet Sag -->
<div class="content-sag col-md-4">
    <div class="side-ads-c">
        @if ($settings->ads_sidebar_top_status == 1)
            {{ $settings->ads_sidebar_top_code }}
        @endif
    </div>

    @if($randomCountries)
    <!-- start COUNTRIES -->
    <div class="modul">
        <div class="titleh">
            @language('u_countries')
            <a href="{{ route('site.country') }}" class="icon text">@language('more')</a>
        </div>
        <ul class="side-list">
            @foreach($randomCountries as $country)
                <li><a href="{{ route('site.country-websites', [$country['slug']]) }}" title="{{ $country['name'] }}"><img src="{{ asset('img/flags2/' . $country['short_name'] . '.png') }}" alt="img" class="flag">{{ Str::limit($country['name'], 17) }}<span>{{ standard_number($country['website_count']) }} site</span></a></li>
            @endforeach
        </ul>
    </div>
    <!-- end COUNTRIES -->
    @endif

    <div class="side-ads">
        @if ($settings->ads_sidebar_bottom_status == 1)
            {{ $settings->ads_sidebar_bottom_code }}
        @endif
    </div>

    @if($recentWebSites)
    <!-- start LAST ANALYSED -->
    <div class="modul">
        <div class="titleh">
            @language('last_analysed_websites')
        </div>
        <ul class="side-list">
            @foreach($recentWebSites as $site)
                <li><a href="{{ route('site.name', [$site['name']]) }}"><img src="{{ favicon_url($site['name']) }}" alt="img" class="favicon">{{ Str::title($site['name']) }}<span class="float-r"><img src="{{ asset('img/flags2/' . $site['country_code'] . '.png') }}" alt="img" class="flag"></span></a></li>
            @endforeach
        </ul>
    </div>
    <!-- end COUNTRIES -->
    @endif

    <!-- start button -->
    <div class="margin-b-20">
        <a href="#" class="button display-button remove-my-website" data-title="@language('remove_website_message')" data-desc="@language('remove_website_message_title')" data-ajax-url="{{ route('ajax.remove-site') }}">@language('remove_website_button')</a>
    </div>
    <!-- end button -->

    @if(Route::currentRouteName() == 'site.name')
    <!-- start share -->

    <div class="margin-b-20">
        <a href="{{ route('site.report', [$id]) }}" class="button display-button report-website">@language('report_website_button')</a>
    </div>

    <div id="share">
        <h1>SHARE THIS ANALYSIS</h1>

        @if($settings->share_facebook)
            <a href="https://www.facebook.com/sharer/sharer.php?u={{ route('site.name', $name) }}" target="_blank" class="social-btn facebook-btn">
                <i class="fa fa-facebook"></i>
            </a>
        @endif
        @if($settings->share_twitter)
            <a href="https://twitter.com/home?status={{ route('site.name', $name) }}" target="_blank" class="social-btn twitter-btn">
                <i class="fa fa-twitter"></i>
            </a>
        @endif
        @if($settings->share_google_plus)
            <a href="https://plus.google.com/share?url={{ route('site.name', $name) }}" target="_blank" class="social-btn google-plus-btn">
                <i class="fa fa-google-plus"></i>
            </a>
        @endif
        @if($settings->share_pinterest)
            <a href="https://pinterest.com/pin/create/button/?url={{ $name }}&media=https://free4.pagepeeker.com/v2/thumbs.php?size=x&url={{ route('site.name', $name) }}" target="_blank" class="social-btn pinterest-btn">
                <i class="fa fa-pinterest"></i>
            </a>
        @endif
        @if($settings->share_tumblr)
            <a href="https://www.tumblr.com/share/link?url={{ route('site.name', $name) }}" target="_blank" class="social-btn tumblr-btn">
                <i class="fa fa-tumblr"></i>
            </a>
        @endif
        @if($settings->share_linkedin)
            <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ route('site.name', $name) }}" target="_blank" class="social-btn linkedin-btn">
                <i class="fa fa-linkedin"></i>
            </a>
        @endif
        @if($settings->share_delicious)
            <a href="https://del.icio.us/post?url={{ route('site.name', $name) }}" target="_blank" class="social-btn delicious-btn">
                <i class="fa fa-delicious"></i>
            </a>
        @endif
        @if($settings->share_stumbleupon)
            <a href="https://www.stumbleupon.com/submit?url={{ $name }}" target="_blank" class="social-btn stumbleupon-btn">
                <i class="fa fa-stumbleupon"></i>
            </a>
        @endif
        @if($settings->share_reddit)
            <a href="https://www.reddit.com/login?dest=https://www.reddit.com/submit?url={{ route('site.name', $name) }}&title={{ $name }}" target="_blank" class="social-btn reddit-btn">
                <i class="fa fa-reddit"></i>
            </a>
        @endif
        @if($settings->share_digg)
            <a href="https://digg.com/submit?phase=2&url={{ route('site.name', $name) }}" target="_blank" class="social-btn digg-btn">
                <i class="fa fa-digg"></i>
            </a>
        @endif


        <div class="cb"></div>

    </div>

    @endif

</div>
<!-- Content Sag -->

