@if ($paginator->getLastPage() > 1)
    <ul class="pagenation">
        @if($paginator->canShowFirstPage())
            <li><a href="{{ $paginator->withoutQuery()->getUrl(1) }}">First</a></li>
        @endif
        @foreach ($paginator->getPagesRange() as $page)
            @if($paginator->getCurrentPage() == $page)
                <li><span class="active-page">{{ $page }}</span></li>
            @else
                <li><a href="{{ $paginator->withoutQuery()->getUrl($page) }}">{{ $page }}</a></li>
            @endif
        @endforeach
        @if($paginator->canShowLastPage())
            <li><a href="{{ $paginator->withoutQuery()->getUrl($paginator->getLastPage()) }}">Last</a></li>
        @endif
    </ul>
@endif