<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="{{ asset('img/favicon.png') }}" />

    <title>Install - Smart Website Analyzer</title>

    <!-- Css Files -->
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,700' rel='stylesheet' type='text/css'>
    <link href='https://fonts.googleapis.com/css?family=Montserrat:400,700' rel='stylesheet' type='text/css'>
    <link href="{{ asset('css/reset.css') }}" rel="stylesheet">
    <link href="{{ asset('css/bootstrap.css') }}" rel="stylesheet">
    <link href="{{ asset('css/bootstrap-dialog.css') }}" rel="stylesheet">
    <link href="{{ asset('css/install.css') }}" rel="stylesheet">
    <link href="{{ asset('css/shortcuts.css') }}" rel="stylesheet">
    <link href="{{ asset('css/responsive.css') }}" rel="stylesheet">
    <link href="{{ asset('css/font-awesome.min.css') }}" rel="stylesheet">
    <link href="{{ asset('css/sweet-alert.css') }}" rel="stylesheet">

</head>

<body>

    <a href="#header" class="pagetop" style="display: none"><img src="{{ asset('img/pagetop.png') }}" alt="Go Top"></a>

    <!-- START HEADER -->
    <div id="header">
        <div class="container text-center">
            <div class="row">
                <ul class="menu col-md-12">
                    <li class="logo"><a href="{{ route('index') }}"><img src="{{ asset('img/logo.png') }}" alt="logo" style="margin-top: -8px"></a></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- END HEADER -->

    <!-- Start Content -->
    <div class="install-box content" id="installation">

        <!-- Start Content -->
        <div class="content-sol col-md-12">

            <h1 class="st-h1">INSTALLATION</h1>
            <p class="padding-t-10 main-p"><strong>Welcome to Smart Website Analyzer !</strong></p>
            <p class="main-p"></p>

            <div class="post-form">

                <div class="modul">
                    <div class="titleh">Extensions</div>

                    <!-- Start Table -->
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead class="tabletitle">
                                <tr>
                                    <td>Extension</td>
                                    <td class="text-r">Status</td>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach($extensions as $ext => $value)
                                    <tr>
                                        <td>{{ $ext }}</td>
                                        <td class="text-r">@if($value == 1)<img src="{{ asset('img/true-icon.png') }}" alt="img" height="20">@else<img src="{{ asset('img/false-icon.png') }}" alt="img" height="20">@endif</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- End Table -->

                </div>

            </div>

            <div class="post-form">

                <div class="modul">
                    <div class="titleh">Permissions</div>

                    <!-- Start Table -->
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead class="tabletitle">
                                <tr>
                                    <td>Folder & File</td>
                                    <td class="text-r">Status</td>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach($permissions as $permission)
                                    <tr>
                                        <td>{{ $permission['name'] }}</td>
                                        <td class="text-r">@if($permission['is_writable'] == 1)<img src="{{ asset('img/true-icon.png') }}" alt="img" height="20">@else<img src="{{ asset('img/false-icon.png') }}" alt="img" height="20">@endif</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- End Table -->

                </div>

            </div>

            <!-- START FORM -->
            <div class="post-form margin-t-30">
                <h2>Database Information</h2>
                <form id="installForm" action="{{ route('install-process') }}">
                    <input type="text" name="database_name" class="form-control stinput" placeholder="Database Name" autocomplete="off">
                    <input type="text" name="database_user" class="form-control stinput" placeholder="Database Username (Your MySQL Username.)" autocomplete="off">
                    <input type="password" name="database_pass" class="form-control stinput" placeholder="Database Password (Your MySQL password.)" autocomplete="off">
                    <input type="text" name="database_host" class="form-control stinput" placeholder="Database Host (Example: localhost)" autocomplete="off">

                    <div class="clear"></div>

                    <button id="install" type="submit" class="button">Install Smart Website Analyzer</button>

                </form>
            </div>
            <!-- END FORM -->

        </div>
        <!-- End Content -->

        <div class="clear"></div>

    </div>
    <!-- End Content -->

    <!-- Start Content -->
    <div class="install-box content margin-t-20 text-center hidden" id="installed">

        <!-- Start Content -->
        <div class="content-sol col-md-12">
            <img src="{{ asset('img/check-icon.png') }}" width="150" />

            <h3 class="main-p padding-t-10"><strong>Smart Website Analyzer script installed !</strong></h3>
            <p class="main-p margin-b-15">Thank you for choosing our product</p>
            <p>
                If you upload a website list and want an automatic analysis over the list, then you should define the line below in the "cron jobs" section of your hosting control panel with 1 minute of trigger intervals.
            </p>

            <div class="code">php {{ base_path('artisan') }} cron:run</div>

            <a href="{{ route('account.login') }}" class="login-link">Click to Login</a>
            <div class="clear"></div>

        </div>
        <!-- End Content -->

        <div class="clear"></div>

    </div>
    <!-- End Content -->


    <!-- START FOOTER -->
    <div id="footer">
        <div class="top col-md-12">
            <div class="container text-center">
                Copyright © 2015 <a href="http://www.creacodes.com" target="_blank" class="underline">CreaCodes</a>. All rights reserved.
            </div>
        </div>
    </div>
    <!-- END FOOTER -->

    <!-- //////// JS Files ////////  -->
    <script type="text/javascript" src="{{ asset('js/jquery.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/bootstrap.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/bootstrap-dialog.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/sweet-alert.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/install.js') }}"></script>
</body>
</html>