@extends('layouts.master')

@section('scripts')
    <script type="text/javascript" src="{{ asset('js/index.js') }}"></script>
@stop

@section('content')

<!-- START INDEX MAIN -->
<div class="index-main">
    <div class="container">
        <h1>@language('slogan')</h1>
        <h2>@language('slogan_desc')</h2>
        <form action="{{ URL::route('ajax.search') }}" id="main-search-form">
            <input type="text" name="url" class="form-control index-search-input" placeholder="@language('enter_website_address')">
            <button type="submit" id="search-button" class="index-button">@language('analyze_button')</button>
        </form>
    </div>
</div>
<!-- END INDEX MAIN -->


<!-- START INDEX ICON DIV -->
<div class="index-icondiv">
    <div class="container clearfix">

        <div class="col col-md-4">
            <div class="icon"><img src="{{ asset('img/indexicon1.png') }}" alt="icon"></div>
            <h1>@language('block_1_title')</h1>
            <p class="text">@language('block_1_desc')</p>
        </div>

        <div class="col col-md-4">
            <div class="icon"><img src="{{ asset('img/indexicon2.png') }}" alt="icon"></div>
            <h1>@language('block_2_title')</h1>
            <p class="text">@language('block_2_desc')</p>
        </div>

        <div class="col col-md-4">
            <div class="icon"><img src="{{ asset('img/indexicon3.png') }}" alt="icon"></div>
            <h1>@language('block_3_title')</h1>
            <p class="text">@language('block_3_desc')</p>
        </div>

    </div>
</div>
<!-- END INDEX ICON DIV -->

@if($recentWebSites)
<!-- START RECENT WEBSITES -->
<div class="index-recent">
    <div class="container">
        <h1>@language('recent_web_sites')</h1>

        <!-- Start Table -->
        <div class="table-responsive">
            <table class="table table-striped">
                <thead class="tabletitle">
                <tr>
                    <td></td>
                    <td>URL</td>
                    <td>@language('country')</td>
                    <td class="text-c">@language('alexa_rank')</td>
                    <td class="text-c">Page Rank</td>
                </tr>
                </thead>
                <tbody>
                @foreach($recentWebSites as $site)
                    <tr>
                        <td><img src="{{ favicon_url($site['name']) }}"></td>
                        <td><a href="{{ route('site.name', [$site['name']]) }}">{{ Str::title($site['name']) }}</a></td>
                        <td><img src="{{ asset('img/flags2/'. $site['country_code'] .'.png') }}" alt="img" class="flag">{{ $site['country_name'] }}</td>
                        <td class="text-c">@if($site['alexarank'] > 0){{ standard_number($site['alexarank']) }}@else no-data @endif</td>
                        <td class="text-c"><span class="mark-blue">@if($site['pagerank'] >= 0) {{ $site['pagerank'] }} @else - @endif</span></td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        <!-- End Table -->
    </div>

</div>
<!-- END RECENT WEBSITES -->
@endif

@if($randomCountries)
<!-- START COUNTRY -->
<div class="index-country">
    <div class="container">
        <ul class=" clearfix">
            @foreach($randomCountries as $country)
                <li class="col-md-3 col-sm-6"><a href="{{ route('site.country-websites', [$country['slug']]) }}" title="{{ $country['name'] }}"><img src="{{ asset('img/flags2/' . $country['short_name'] . '.png') }}" alt="img" class="flag">{{ Str::limit($country['name'], 17) }}<span class="rcol"><b>{{ standard_number($country['website_count']) }}</b> site</span></a></li>
            @endforeach
        </ul>
        <a href="{{ route('site.country') }}" class="moredisplay">@language('more_countries')</a>
    </div>
</div>
<!-- END COUNTRY -->
@endif

@stop