@extends('layouts.master')

@section('metas')
<title>{{ $name }} - {{{ Str::limit($metaData['site_title'], 50) }}} - {{ $settings->site_name }}</title>
<meta name="description" content="{{ $name }} analysis | Alexa Rank: @if($alexaData['global_rank'] > 0){{ standard_number($alexaData['global_rank']) }}@else no-data @endif, Server Location: {{ $whoisData['server_country_name'] }}"/>
<meta name="keywords" content="{{ $name }}, {{{ Str::limit($metaData['site_keywords'], 230) }}}"/>
<meta name="og:url" content="{{ route('site.name', [$name]) }}"/>
<meta name="og:title" content="{{ $name }} Web Analysis Results"/>
<meta name="og:description" content="{{ $name }} analysis | Alexa Rank: @if($alexaData['global_rank'] > 0){{ standard_number($alexaData['global_rank']) }}@else no-data @endif, Server Location: {{ $whoisData['server_country_name'] }}"/>
@if($colorData && count($colorData['color_palette']) > 10)
<meta name="og:image" content="{{ asset('screenshots/'. md5($name) .'.png') }}"/>
@endif
@stop

@section('scripts')

    <script type="text/javascript" src="https://www.google.com/jsapi"></script>
    <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key={{ $settings->api_google_key }}"></script>
    <script type="text/javascript" src='https://www.google.com/recaptcha/api.js'></script>

    <script type="text/javascript" src="{{ asset('js/stickymenu.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/chart.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/justgage.1.0.1.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/raphael.2.1.0.min.js') }}"></script>

    <script type="text/javascript">
        var latitude = '{{ $whoisData['server_country_latitude'] }}';
        var longitude = '{{ $whoisData['server_country_longitude'] }}';
        var pagespeed = '{{ $searchData['google_page_speed_score'] }}';
    </script>

    <script type="text/javascript" src="{{ asset('js/details.js') }}"></script>
    <script type="text/javascript">
    var site = '{{ $name }}';
    @if($keywordDensity && count($keywordDensity) > 1)
    var keywordDensityData = [
        @foreach($keywordDensity as $keyword)
            {
            value: {{ $keyword['website_count'] }},
            color: '{{ $keyword['color'] }}',
            highlight: Colour('{{ $keyword['color'] }}', 10),
            label: "{{{ censor($keyword['keyword']) }}}"
            },
        @endforeach
    ];
    @endif
    var alexaTopCountries = [
    ['Country', 'Ratio'],
    @if($alexaData['top_countries'])
        @foreach($alexaData['top_countries'] as $index=>$country)
            @if($index < 5)
                ['{{ $country['name'] }}', {{ str_replace('%', '', $country['ratio']) }}],
            @endif
        @endforeach
    @endif
    ];

    var codeSize = '{{ format_bytes($htmlData['code_size']) }}';
    var textSize = '{{ format_bytes($htmlData['text_size']) }}';
    </script>

@stop

@section('content')

    <div class="container">
        <ol class="breadcrumb">
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="{{ route('index') }}" itemprop="url"><span itemprop="title">@language('home')</span></a></li>
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb" itemprop="child"><a href="{{ route('site.country') }}" itemprop="url"><span itemprop="title">@language('countries')</span></a></li>
            @if($whoisData['server_country_name'])
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb" itemprop="child"><a href="{{ route('site.country-websites', [Str::slug($whoisData['server_country_name'])]) }}" itemprop="url"><span itemprop="title">{{ $whoisData['server_country_name'] }}</span></a></li>
            @endif
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb" itemprop="child" class="active"><a href="{{ route('site.name', [$name]) }}" itemprop="url"><span itemprop="title">{{ $name }}</span></a></li>
        </ol>
    </div>

    <div id="mobile-fixed-menu">
        <a href="#" class="mobile-menu-button"><img src="{{ asset('img/mobilemenu.png') }}" alt="mobile"></a>
        <a href="#" class="mobile-top-button"><img src="{{ asset('img/mobiletop.png') }}" alt="mobile"></a>
        <a href="{{ route('index') }}" class="logo"><img src="{{ asset('img/' . $layout->site_logo) }}" alt="logo"></a>
    </div>

    <!-- Start Sticky Menu Mobile-->
    <ul class="stickymenu-mobile">
        <li><a href="#meta">META</a></li>
        <li><a href="#search-engines">@language('search_engines')</a></li>
        @if($searchData['google_page_speed_score'] > 0)<li><a href="#page-speed">@language('page_speed')</a></li>@endif
        @if($alexaData['global_rank'] > 0)<li><a href="#alexa">ALEXA</a></li>@endif
        <li><a href="#html">HTML</a></li>
        @if($dmozData)<li><a href="#dmoz">DMOZ</a></li>@endif
        <li><a href="#links">@language('link_analysis')</a></li>
        @if($colorData && count($colorData['color_palette']) > 10 && File::exists(public_path('screenshots/'. md5($name) .'.png')))
        <li><a href="#colors">@language('colors')</a></li>
        @endif
        @if($whoisData['created_date'] > 0 || $whoisData['updated_date'] > 0 || $whoisData['expired_date'] > 0)
        <li><a href="#domain">@language('domain')</a></li>
        @endif
        @if($whoisData['server_ip_address'] && $whoisData['server_country_latitude'] && $whoisData['server_country_longitude'])
        <li><a href="#server">@language('server')</a></li>
        @endif
        <li><a href="#social">@language('social')</a></li>
    </ul>
    <!-- End Sticky Menu Mobile -->

    <!-- START STAT TITLE -->
    <div class="stattitle container">
        <div class="col-md-4">
            <h1>@language('website_analysis')</h1>
            <h4>
            @if ($settings->wap_analyzed_website_link == 1)
                <a href="http://{{ $name }}" target="_blank">{{ Str::title($name) }}</a>
            @else
                {{ Str::title($name) }}
            @endif
            </h4>
            <div class="re-analyze">
                <button id="re-analyze" type="submit" class="update-button margin-r-5" data-url="{{ route('ajax.re-analyze') }}" data-name="{{ $name }}"><i class="fa fa-refresh margin-r-2"></i> @language('re_analyze_button')</button>
                @language('last_analyzed') : {{ date('d.m.Y', strtotime($siteData->analyzed_at)) }}
            </div>
        </div>
        <div class="col-md-8">
            @if ($settings->ads_wtp_header_status == 1)
                {{ $settings->ads_wtp_header_code }}
            @endif
        </div>

    </div>
    <!-- END STAT TITLE -->

    <!-- Start Content -->
    <div class="container content analyze-container">

        <div class="stickymenu-container" id="general-info">
            <div class="stickymenu">
                <div class="sticky-bg"></div>
                <ul>
                    <li><a href="#general">@language('general')</a></li>
                    <li><a href="#meta">META</a></li>
                    <li><a href="#search-engines">@language('search_engines')</a></li>
                    @if($searchData['google_page_speed_score'] > 0)<li><a href="#page-speed">@language('page_speed')</a></li>@endif
                    @if($alexaData['global_rank'] > 0)<li><a href="#alexa">ALEXA</a></li>@endif
                    <li><a href="#html">HTML</a></li>
                    @if($dmozData)<li><a href="#dmoz">DMOZ</a></li>@endif
                    <li><a href="#links">@language('link_analysis')</a></li>
                    @if($colorData && count($colorData['color_palette']) > 10 && File::exists(public_path('screenshots/'. md5($name) .'.png')))
                    <li><a href="#colors">@language('colors')</a></li>
                    @endif
                    @if($whoisData['created_date'] > 0 || $whoisData['updated_date'] > 0 || $whoisData['expired_date'] > 0)
                    <li><a href="#domain">@language('domain')</a></li>
                    @endif
                    @if($whoisData['server_ip_address'] && $whoisData['server_country_latitude'] && $whoisData['server_country_longitude'])
                    <li><a href="#server">@language('server')</a></li>
                    @endif
                    <li><a href="#social">@language('social')</a></li>
                    @if(count($adsenseUsedSites) > 1 || count($sameIpAddressSites) > 1 || $cClassIpAddressSites)
                    <li><a href="#other">@language('other')</a></li>
                    @endif
                </ul>
            </div>
        </div>


        <!-- Start Content Sol -->
        <div class="content-sol col-md-8">

            <!-- Start General -->
            <div id="general" class="general margin-b-20">
                <div class="col-md-6">
                    @if (File::exists(public_path('screenshots/'. md5($name) .'.png')))
                        <img src="{{ asset('screenshots/'. md5($name) .'.png') }}" class="website-screenshot img-thumbnail" id="website-screenshot" width="100%" alt="{{ $name }}" />
                    @else
                        <img src="{{ asset('img/default-screenshot.png') }}" class="website-screenshot img-thumbnail" width="100%" alt="{{ $name }}" />
                    @endif
        	    </div>
                <div class="col-md-6">
                    <ul class="info-ul">

                        <li><span class="title">@language('website_age')
                            </span> {{ elapsed_time($whoisData['created_date']) }}</li>
                        <li><span class="title">Google Pagerank</span><span class="mark-blue">@if($searchData['google_pagerank'] == -1) Not rated yet @else {{ $searchData['google_pagerank'] }} @endif</span></li>
                        <li><span class="title">Alexa Rank</span><u>@if($alexaData['global_rank'] > 0){{ standard_number($alexaData['global_rank']) }}@else no-data @endif</u></li>
                        <li><span class="title">DMOZ</span>@if($dmozData)<span class="mark-green">@language('yes')</span>@else<span class="mark-red">@language('no')</span>@endif</li>
                        @if($whoisData['server_country_name'])
                        <li><span class="title">@language('country')
                            </span><a href="{{ route('site.country-websites', [Str::slug($whoisData['server_country_name'])]) }}"><img src="{{ asset('img/flags2/' . Str::lower($whoisData['server_country_short_name']) . '.png') }}" alt="img" class="flag">{{ $whoisData['server_country_name'] }}</a></li>
                        @endif
                        @if($whoisData['server_ip_address'])
                        <li><span class="title">@language('ip_address')
                            </span>{{ $whoisData['server_ip_address'] }}</li>
                        @endif
                        @if($searchData['google_is_banned'] > -1)
                        <li><span class="title">Google Ban</span>@if($searchData['google_is_banned'])<span class="mark-red">@language('banned')
                            </span>@else<span class="mark-green">@language('no')
                            </span>@endif</li>
                        @endif
                    </ul>
                </div>
                <div class="clearfix"></div>
            </div>
            <!-- End General -->
            <div class="analyze-group" id="meta">
                <!-- Start Meta Info -->
                <div class="row">

                    <div class="modul">
                        <div class="titleh">
                            @language('meta_information')
                            <a href="#" class="icon info-modal" data-title="Meta Information" data-xhr-url="/ajax/data/meta"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <div class="modul-list">
                            <div class="row">
                                <div class="col-sm-3 list-title">@language('title')</div>
                                <div class="col-sm-9">@if($metaData['site_title']) {{{ Str::limit(censor($metaData['site_title']), 500) }}} @else - @endif</div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3 list-title">@language('description')</div>
                                <div class="col-sm-9">@if($metaData['site_description']) {{{ Str::limit(censor($metaData['site_description']), 600) }}} @else - @endif</div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3 list-title">@language('keywords')</div>
                                <div class="col-sm-9">@if($metaData['site_keywords']) {{{ Str::limit(censor($metaData['site_keywords']), 500) }}} @else - @endif</div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3 list-title">@language('content_type')</div>
                                <div class="col-sm-9">@if($metaData['site_content_type']) {{{ $metaData['site_content_type'] }}} @else - @endif</div>
                            </div>
                        </div>
                        @if($metaData['others'])
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead class="tabletitle">
                                <tr>
                                    <td width="80">No</td>
                                    <td width="200">@language('meta_name')</td>
                                    <td>@language('value')</td>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($metaData['others'] as $index=>$meta)
                                    <tr @if($index >= $settings->table_row_limit) class="hidden" @endif >
                                        <td>{{ $index+1 }}</td>
                                        <td>{{{ $meta['name'] }}}</td>
                                        <td>{{{ censor($meta['content']) }}}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>

                            @if(count($metaData['others']) > $settings->table_row_limit)
                                <div class="more-grp">
                                    <a href="#" class="button-small see-more-table">SEE MORE</a>
                                </div>
                            @endif
                        </div>
                        @endif

                    </div>

                </div>
                <!-- End Meta Info -->

                @if($keywordDensity)
                <!-- Start Anahtar Kelimeler -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('keywords_density')
                            <a href="#" class="icon info-modal" data-title="Keywords Density" data-xhr-url="/ajax/data/keywords-density"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>
                        @if(count($keywordDensity) > 1)
                        <!-- Start Chart -->
                        <div class="chart row meta-chart">
                            <div class="col-md-6 chart-area">
                                <div class="meta-chart-container">
                                    <canvas id="meta-char-doughnut" height="275" style="height: 275px;"></canvas></div>
                                </div>
                            <div class="col-md-6 col-xs-6 sub-div">
                                <div class="legend-container"></div>
                            </div>
                        </div>
                        <!-- End Chart -->
                        @endif
                        <!-- Start Table -->
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead class="tabletitle">
                                <tr>
                                    <td width="80">No</td>
                                    <td width="500">@language('keyword')</td>
                                    <td class="text-r" width="153">@language('website_count')</td>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($keywordDensity as $index=>$keyword)
                                    <tr @if($index >= $settings->table_row_limit) class="hidden" @endif >
                                        <td>{{ $index+1 }}</td>
                                        <td>{{{ censor($keyword['keyword']) }}}</td>
                                        <td class="text-r">{{{ number_format($keyword['website_count']) }}}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>

                            @if(count($keywordDensity) > $settings->table_row_limit)
                                <div class="more-grp">
                                    <a href="#" class="button-small see-more-table">@language('see_more')</a>
                                </div>
                            @endif
                        </div>
                        <!-- End Table -->


                    </div>

                </div>
                <!-- End Anahtar Kelimeler -->
            @endif
            </div>
            <div class="analyze-group" id="search-engines">
                <!-- Start Search Engines -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('search_engines')
                            <a href="#" class="icon info-modal" data-title="Search Engines" data-xhr-url="/ajax/data/search-engines"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <!-- Start Table -->
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead class="tabletitle">
                                <tr>
                                    <td>@language('search_engine')</td>
                                    <td class="text-c" width="150">@language('index')</td>
                                    <td class="text-c" width="150">@language('image_index')</td>
                                    <td class="text-c" width="150">Backlink</td>
                                </tr>
                                </thead>
                                <tbody>

                                <tr>
                                    <td><img src="{{ asset('img/google.png') }}" height="20" alt=img></td>
                                    <td class="text-c">@if($searchData['google_index_count'] > -1) {{ standard_number($searchData['google_index_count']) }} @else N/A @endif</td>
                                    <td class="text-c">N/A</td>
                                    <td class="text-c">@if($searchData['google_backlink_count'] > -1){{ standard_number($searchData['google_backlink_count']) }}@else N/A @endif</td>
                                </tr>

                                @if(isset($searchData['bing_index_count']) && array_key_exists('bing_index_count', $searchData))
                                <tr>
                                    <td><img src="{{ asset('img/bing.png') }}" height="20" alt=img></td>
                                    <td class="text-c">{{ standard_number($searchData['bing_index_count']) }}</td>
                                    <td class="text-c">{{ standard_number($searchData['bing_image_count']) }}</td>
                                    <td class="text-c">-</td>
                                </tr>
                                @endif

                                @if(isset($searchData['yahoo_index_count']) && array_key_exists('yahoo_index_count', $searchData))
                                <tr>
                                    <td><img src="{{ asset('img/yahoo.png') }}" height="20" alt=img></td>
                                    <td class="text-c">{{ standard_number($searchData['yahoo_index_count']) }}</td>
                                    <td class="text-c">{{ standard_number($searchData['yahoo_image_count']) }}</td>
                                    <td class="text-c">{{ standard_number($searchData['yahoo_backlink_count']) }}</td>
                                </tr>
                                @endif

                                </tbody>
                            </table>
                        </div>
                        <!-- End Table -->

                    </div>

                </div>
                <!-- End Search Engines -->
            </div>

            @if($searchData['google_page_speed_score'] > 0)
            <div class="analyze-group" id="page-speed">
                <!-- Start Page Speed -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('page_speed')
                            <a href="#" class="icon info-modal" data-title="Pagespeed" data-xhr-url="/ajax/data/pagespeed"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <div class="padding-20 clearfix">
                            <div class="col-md-6 gauge-container">
                                <div id="pagespeed-gauge" class="pagespeed-gauge"></div>
                            </div>
                            <div class="col-md-6">
                                <div class="meter-deger">
                                    <h2>{{ $searchData['google_page_speed_score'] }} / 100</h2>
                                    <h4>@language('l_page_speed')</h4>
                                    <p>@language('page_speed_desc', ['url' => $name, 'value' => $searchData['google_page_speed_value']])</p>
                                </div>
                            </div>
                        </div>


                    </div>

                </div>
                <!-- End Page Speed -->
            </div>
            @endif

            @if($alexaData['global_rank'] > 0)
            <div class="analyze-group" id="alexa">
                <!-- Start Alexa -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('alexa_graphics')
                            <a href="#" class="icon info-modal" data-title="Alexa Information" data-xhr-url="/ajax/data/alexa"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <ul id="alexa-graph-tab" class="horizonal-menu alexa-menu">
                            <li><a href="#" data-type-id="t" class="active">@language('alexa_traffic_rank')</a></li>
                            <li><a href="#" data-type-id="r" >@language('alexa_reach')</a></li>
                            <li><a href="#" data-type-id="p" >@language('alexa_pageviews')</a></li>
                            <li><a href="#" data-type-id="u" >@language('alexa_pageviews_user')</a></li>
                            <li><a href="#" data-type-id="b" >@language('alexa_bounce') %</a></li>
                            <li><a href="#" data-type-id="s" >@language('alexa_time_on_site')</a></li>
                            <li><a href="#" data-type-id="q" >@language('alexa_search') %</a></li>
                        </ul>

                        <div id="alexa-graph-container" class="padding-20 padding-t-10 padding-b-10">
                            <img src="https://traffic.alexa.com/graph?w=690&h=400&o=flt&c=1&y=t&b=ffffff&n=666666&r=7d&f=333333&u={{ $name }}" alt="img" data-template="http://traffic.alexa.com/graph?w=690&h=400&o=flt&c=1&y=%type%&b=ffffff&n=666666&r=%period%&f=333333&u=%site%" style="max-width:100%;"/>
                        </div>

                    </div>

                </div>
                <!-- End Alexa -->
                @if($alexaData['top_countries'])
                    <!-- Start Daily Visitors -->
                    <!-- Start Daily Visitors -->
                    <div class="row">

                        <div class="modul">

                            <div class="titleh">
                                @language('daily_visitors_country_map_analysis')
                                <a href="#" class="icon info-modal" data-title="Country Map Analysis" data-xhr-url="/ajax/data/country-map-analysis"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                            </div>

                            <ul class="horizonal-menu">
                                <li>@language('daily_visitors_country_map_analysis_desc', ['url' => $name ]) - <strong>@language('daily_visitors_country_map_analysis_total', ['count' => $alexaData['top_countries_count']])
                                    </strong></li>
                            </ul>

                            <div class="padding-20">
                                <div class="col-md-7"><div id="alexa-country-map" style="height: 243px;"></div></div>
                                <div class="col-md-5">
                                    <ul id="alexa-country-list" class="st-list">
                                        @foreach($alexaData['top_countries'] as $index=>$country)
                                            <li>@if($country['name'] != 'Other')<img src="{{ asset('img/flags2/'. $country['short_name'] .'.png') }}" alt="img" class="flag">@else <img src="{{ asset('img/other-icon.png') }}" class="flag"/> @endif<b>{{ $country['name'] }}</b> ({{ $country['ratio'] }} @language('visitors'))</li>
                                        @endforeach
                                    </ul>
                                </div>
                                <div class="clear"></div>
                            </div>

                        </div>

                    </div>
                    <!-- End Daily Visitors -->
                @endif


                @if($alexaData['top_countries'] || $alexaData['top_keywords'])
                    <!-- Start Traffic Analysis -->
                    <div class="row">

                        <div class="modul">

                            <div class="titleh">
                                @language('traffic_analysis')
                                <a href="#" class="icon info-modal" data-title="Traffic Analysis" data-xhr-url="/ajax/data/traffic-analysis"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                            </div>

                            <ul id="alexa-traffic-tabs" class="horizonal-menu clearfix">
                                <a href="#alexa-country-ranks" class="tabbutton float-l @if($alexaData['top_countries']) active @endif">@language('country_ranks')</a>
                                <a href="#alexa-top-keywords" class="tabbutton float-r @if(!$alexaData['top_countries']) active @endif">@language('top_keywords')</a>
                            </ul>

                            <!-- Start Table -->
                            <div class="table-responsive">

                                <table id="alexa-country-ranks" class="table table-striped alexa-tables" @if(!$alexaData['top_countries']) style="display: none;" @endif>
                                    <thead class="tabletitle">
                                    <tr>
                                        <td width="75">No</td>
                                        <td width="400">@language('country')</td>
                                        <td class="text-r" width="113">@language('rank')</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @if($alexaData['top_countries'])
                                        @foreach($alexaData['top_countries'] as $index=>$country)
                                            @if($country['name'] != 'Other')
                                                <tr>
                                                    <td>{{ $index+1 }}</td>
                                                    <td><img src="{{ asset('img/flags2/'. $country['short_name'] .'.png') }}" alt="img" class="flag">{{ $country['name'] }}</td>
                                                    <td class="text-r">{{ $country['rank'] }}</td>
                                                </tr>
                                            @endif
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="3" align="center"><strong>No-data</strong></td>
                                        </tr>
                                    @endif
                                        </tbody>
                                </table>

                                <!-- End Table -->

                                <!-- Start Table -->
                                <table id="alexa-top-keywords" class="table table-striped alexa-tables" @if($alexaData['top_countries']) style="display: none;" @endif>
                                    <thead class="tabletitle">
                                    <tr>
                                        <td width="75">No</td>
                                        <td width="400">@language('keyword')</td>
                                        <td class="text-r" width="113">@language('alexa_search')</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @if($alexaData['top_keywords'])
                                        @foreach($alexaData['top_keywords'] as $index=>$keyword)
                                            <tr>
                                                <td>{{ $index+1 }}</td>
                                                <td>{{ ucfirst_tr(censor($keyword['name'])) }}</td>
                                                <td class="text-r">{{ $keyword['ratio'] }}</td>
                                            </tr>
                                        @endforeach
                                    @endif
                                    </tbody>
                                </table>

                            </div>
                            <!-- End Table -->

                        </div>

                    </div>
                    <!-- End Traffic Analysis -->
                @endif
            </div>
            @endif

            <div class="analyze-group" id="html">
                <!-- Start Genel HTML -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('html_general_information')
                            <a href="#" class="icon info-modal" data-title="HTML Information" data-xhr-url="/ajax/data/html"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <!-- Start Table -->
                        <table class="table table-striped">
                            <thead class="tabletitle">
                            <tr>
                                <td>@language('type')</td>
                                <td class="text-r">@language('status')</td>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>HTML 5</td>
                                <td class="text-r">@if($htmlData['html5_support'])<img src="{{ asset('img/true-icon.png') }}" alt="img" height="20">@else<img src="{{ asset('img/false-icon.png') }}" alt="img" height="20">@endif</td>
                            </tr>
                            <tr>
                                <td>@language('website_responsive')</td>
                                <td class="text-r">@if($htmlData['responsive_support'])<img src="{{ asset('img/true-icon.png') }}" alt="img" height="20">@else<img src="{{ asset('img/false-icon.png') }}" alt="img" height="20">@endif</td>
                            </tr>

                            </tbody>
                        </table>
                        <!-- End Table -->

                    </div>

                </div>
                <!-- End Genel HTML -->

                @if($htmlData['code_text_ratio'] > 0)
                <!-- Start HTML Size -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('html_size_information')
                            <a href="#" class="icon info-modal" data-title="HTML Size Information" data-xhr-url="/ajax/data/html-size"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <!-- Start Chart -->
                        <div class="chart html-size-chart">
                            <div class="col-md-4 col-sm-6 chart-canvas-container"> <canvas id="html-size-doughnut" width="198" height="198" style="width: 198px; height: 198px;"></canvas></div>
                            <div class="col-md-4 col-sm-6">
                                <div class="legend-container" data-html-size="{{ format_bytes($htmlData['html_size']) }}" data-text-size="{{ format_bytes($htmlData['text_size']) }}" data-code-size="{{ format_bytes($htmlData['code_size']) }}"></div>
                                <div class="bluemark">
                                    @language('text_code_ratio')
                                    <span>{{ $htmlData['code_text_ratio'] }} %</span>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12 chart-text">
								@language('html_size_information_desc', ['url' => $name, 'code_text_ratio' => $htmlData['code_text_ratio'] ])
                            </div>
                            <div class="clear"></div>
                        </div>
                        <!-- End Chart -->
                    </div>

                </div>
                <!-- End HTML Size -->
                @endif

                <!-- Start Onemli HTML -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('important_html_tags')
                            <a href="#" class="icon info-modal" data-title="HTML Tags" data-xhr-url="/ajax/data/html-tags"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <!-- start akordiyon title ve icerik -->
                        <a href="#" class="akordiyon">@language('titles')
                            <img src="{{ asset('img/arrow-up.png') }}" alt="icon" class="icon open"></a>
                        <div class="akordiyon-div">
                            <ul class="stats-table">
                                <li>H1<span>{{ $htmlTitleTags['h1']['count'] }}</span></li>
                                <li>H2<span>{{ $htmlTitleTags['h2']['count'] }}</span></li>
                                <li>H3<span>{{ $htmlTitleTags['h3']['count'] }}</span></li>
                                <li>H4<span>{{ $htmlTitleTags['h4']['count'] }}</span></li>
                                <li>H5<span>{{ $htmlTitleTags['h5']['count'] }}</span></li>
                                <li>H6<span>{{ $htmlTitleTags['h6']['count'] }}</span></li>
                            </ul>


                                @foreach($htmlTitleTags as $tagName=>$tags)
                                    @if($tags['tags'])
                                        <div class="marker"><span>{{ Str::upper($tagName) }}</span></div>
                                        <!-- Start Table -->
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead class="tabletitle">
                                                <tr>
                                                    <td width="100">No</td>
                                                    <td>@language('text')</td>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $counter = 0; ?>
                                                @foreach($tags['tags'] as $tag=>$count)
                                                    <tr @if($counter++ >= $settings->table_row_limit) class="hidden" @endif >
                                                        <td>{{ $counter }}</td>
                                                        <td>{{ firstUpperCase(censor($tag)) }}@if($count > 1) <strong>({{ $count }})</strong> @endif</td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>

                                            @if(count($tags['tags']) > $settings->table_row_limit)
                                                <div class="more-grp">
                                                    <a href="#" class="button-small see-more-table">@language('see_more')</a>
                                                </div>
                                            @endif
                                        </div>
                                        <!-- End Table -->
                                    @endif
                                @endforeach

                        </div>
                        <!-- end akordiyon title ve icerik -->

                        <a href="#" class="akordiyon">@language('text_styling')
                            <img src="{{ asset('img/arrow-up.png') }}" alt="icon" class="icon open"></a>

                        <div class="akordiyon-div">
                            <ul class="stats-table">
                                <li>STRONG<span>{{ $htmlStyleTags['strong']['count'] }}</span></li>
                                <li>B<span>{{ $htmlStyleTags['b']['count'] }}</span></li>
                                <li>EM<span>{{ $htmlStyleTags['em']['count'] }}</span></li>
                                <li>I<span>{{ $htmlStyleTags['i']['count'] }}</span></li>
                                <li>U<span>{{ $htmlStyleTags['u']['count'] }}</span></li>
                                <li>CITE<span>{{ $htmlStyleTags['cite']['count'] }}</span></li>
                            </ul>


                            @foreach($htmlStyleTags as $tagName=>$tags)
                                @if($tags['tags'])
                                    <div class="marker"><span>{{ Str::upper($tagName) }}</span></div>
                                    <!-- Start Table -->
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead class="tabletitle">
                                            <tr>
                                                <td width="100">No</td>
                                                <td>@language('text')</td>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $counter = 0;?>
                                            @foreach($tags['tags'] as $tag=>$count)
                                                <tr @if($counter++ >= $settings->table_row_limit) class="hidden" @endif >
                                                    <td>{{ $counter }}</td>
                                                    <td>@if(is_rtl($tag) && $count > 1) <strong>({{ $count }})</strong> @endif{{ censor($tag) }}@if(!is_rtl($tag) && $count > 1) <strong>({{ $count }})</strong> @endif</td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>

                                        @if(count($tags['tags']) > $settings->table_row_limit)
                                            <div class="more-grp">
                                                <a href="#" class="button-small see-more-table">@language('see_more')</a>
                                            </div>
                                        @endif
                                    </div>
                                    <!-- End Table -->
                                @endif
                            @endforeach
                        </div>

                    </div>


                </div>
                <!-- End Onemli HTML -->
            </div>
            @if($dmozData)
            <div class="analyze-group" id="dmoz">
                <!-- Start Dmoz -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('dmoz_information')
                            <a href="#" class="icon info-modal" data-title="DMOZ Information" data-xhr-url="/ajax/data/dmoz"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                            <img src="{{ asset('img/dmoz.png') }}" alt="dmoz" class="logo">
                        </div>

                        <div class="modul-list">
                            <div class="row">
                                <div class="col-sm-3 list-title">@language('dmoz_title')</div>
                                <div class="col-sm-9">{{{ $dmozData['title'] }}}</div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3 list-title">@language('dmoz_category')</div>
                                <div class="col-sm-9"><a href="{{{ $dmozData['category_link'] }}}" target="_blank">{{{ $dmozData['category'] }}}</a></div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3 list-title">@language('dmoz_description')</div>
                                <div class="col-sm-9">{{{ $dmozData['description'] }}}</div>
                            </div>
                        </div>

                    </div>

                </div>
                <!-- End Dmoz -->
            </div>
            @endif


            <div class="analyze-group" id="links">
                <!-- Start Link Analysis -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('link_analysis')
                            <a href="#" class="icon info-modal" data-title="Link Analysis" data-xhr-url="/ajax/data/link-analysis"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <div class="akordiyon">@language('total_link_count'): <b>{{ $htmlData['total_links'] }}</b> </div>

                        @if($htmlData['internal_links'])
                            <a href="#" class="akordiyon">@language('internal_link_count')
                                : <b>{{ $htmlData['internal_links_count'] }}</b> <img src="{{ asset('img/arrow.png') }}" alt="icon" class="icon"></a>
                        @else
                            <div class="akordiyon">@language('internal_link_count')
                                : <b>0</b></div>
                        @endif
                        @if($htmlData['internal_links'])
                            <div class="akordiyon-div table-responsive" style="display: none">
                                <table class="table table-striped">
                                    <thead class="tabletitle">
                                    <tr>
                                        <td width="70">No</td>
                                        <td width="230">@language('text')</td>
                                        <td width="90">@language('type')</td>
                                        <td>URL</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($htmlData['internal_links'] as $index=>$link)
                                        <tr @if($index >= $settings->link_limit) class="hidden" @endif >
                                            <td>{{ $index+1 }}</td>
                                            <td>@if($link['text']){{{ censor($link['text']) }}}@else - @endif</td>
                                            <td>{{{ $link['type'] }}}</td>
                                            <td>{{{ censor($link['href']) }}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>

                                @if(count($htmlData['internal_links']) > $settings->link_limit)
                                    <div class="more-grp">
                                        <a href="#" class="button-small see-more-table">@language('see_more')</a>
                                    </div>
                                @endif
                            </div>
                        @endif

                        @if($htmlData['external_links'])
                            <a href="#" class="akordiyon">@language('external_link_count')
                                : <b>{{ count($htmlData['external_links']) }}</b> <img src="{{ asset('img/arrow.png') }}" alt="icon" class="icon"></a>
                        @else
                            <div class="akordiyon">@language('external_link_count')
                                : <b>0</b></div>
                        @endif

                        @if($htmlData['external_links'])
                            <div class="akordiyon-div table-responsive" style="display: none">
                                <table class="table table-striped">
                                    <thead class="tabletitle">
                                    <tr>
                                        <td width="70">No</td>
                                        <td width="230">@language('text')</td>
                                        <td width="90">@language('type')</td>
                                        <td>URL</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($htmlData['external_links'] as $index=>$link)
                                        <tr @if($index >= $settings->link_limit) class="hidden" @endif >
                                            <td>{{ $index+1 }}</td>
                                            <td>@if($link['text']){{{ censor($link['text']) }}}@else - @endif</td>
                                            <td>{{{ $link['type'] }}}</td>
                                            <td>{{{ censor($link['href']) }}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>

                                @if(count($htmlData['external_links']) > $settings->link_limit)
                                    <div class="more-grp">
                                        <a href="#" class="button-small see-more-table">@language('see_more')</a>
                                    </div>
                                @endif
                            </div>
                        @endif

                        @if($htmlData['nofollow_links'])
                            <a href="#" class="akordiyon">@language('nofolow_link_count')
                                : <b>{{ count($htmlData['nofollow_links']) }}</b> <img src="{{ asset('img/arrow.png') }}" alt="icon" class="icon"></a>
                        @else
                            <div class="akordiyon">@language('nofolow_link_count')
                                : <b>0</b></div>
                        @endif

                        @if($htmlData['nofollow_links'])
                            <div class="akordiyon-div table-responsive" style="display: none">
                                <table class="table table-striped">
                                    <thead class="tabletitle">
                                    <tr>
                                        <td width="70">No</td>
                                        <td width="230">@language('text')</td>
                                        <td width="90">@language('type')</td>
                                        <td>URL</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($htmlData['nofollow_links'] as $index=>$link)
                                        <tr @if($index >= $settings->link_limit) class="hidden" @endif >
                                            <td>{{ $index+1 }}</td>
                                            <td>@if($link['text']){{{ censor($link['text']) }}}@else - @endif</td>
                                            <td>{{{ $link['type'] }}}</td>
                                            <td>{{{ censor($link['href']) }}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>

                                @if(count($htmlData['nofollow_links']) > $settings->link_limit)
                                    <div class="more-grp">
                                        <a href="#" class="button-small see-more-table">@language('see_more')</a>
                                    </div>
                                @endif
                            </div>
                        @endif

                        @if($htmlData['title_links'])
                            <a href="#" class="akordiyon">@language('title_link_count')
                                : <b>{{ count($htmlData['title_links']) }}</b> <img src="{{ asset('img/arrow.png') }}" alt="icon" class="icon"></a>
                        @else
                            <div class="akordiyon">@language('title_link_count')
                                : <b>0</b></div>
                        @endif

                        @if($htmlData['title_links'])
                            <div class="akordiyon-div table-responsive" style="display: none">
                                <table class="table table-striped">
                                    <thead class="tabletitle">
                                    <tr>
                                        <td width="70">No</td>
                                        <td width="230">@language('text')</td>
                                        <td width="90">@language('type')</td>
                                        <td>URL</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($htmlData['title_links'] as $index=>$link)
                                        <tr @if($index >= $settings->link_limit) class="hidden" @endif >
                                            <td>{{ $index+1 }}</td>
                                            <td>@if($link['text']){{{ censor($link['text']) }}}@else - @endif</td>
                                            <td>{{{ $link['type'] }}}</td>
                                            <td>{{{ censor($link['href']) }}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>

                                @if(count($htmlData['title_links']) > $settings->link_limit)
                                    <div class="more-grp">
                                        <a href="#" class="button-small see-more-table">@language('see_more')</a>
                                    </div>
                                @endif
                            </div>
                        @endif

                    </div>

                </div>
                <!-- End Link Analysis -->
            </div>

            @if($colorData && count($colorData['color_palette']) > 10 && File::exists(public_path('screenshots/'. md5($name) .'.png')))
            <div class="analyze-group" id="colors">
                <!-- Start COLOR ANALYSIS -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('color_analysis')
                            <a href="#" class="icon info-modal" data-title="Color Analysis" data-xhr-url="/ajax/data/color"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <!-- Start Chart -->
                        <div class="chart color-palette">
                            <div class="col-md-6 col-sm-6"><img src="{{ asset('screenshots/'. md5($name) .'.png') }}" width="100%" alt="{{ $name }}"/></div>
                            <div class="col-md-6 col-sm-6">
                                <div class="legend-container">
                                    <ul class="doughnut-legend">
                                        @foreach($colorData['color_palette'] as $code=>$ratio)
                                            <li><span style="background-color:#{{ $code }}"></span>#{{ $code }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>

                            <div class="clear"></div>
                        </div>
                        <!-- End Chart -->
                    </div>

                </div>
                <!-- End COLOR ANALYSIS -->
            </div>
            @endif

            @if($whoisData['created_date'] > 0 || $whoisData['updated_date'] > 0 || $whoisData['expired_date'] > 0 || $whoisData['server_ns_records'])
            <div class="analyze-group" id="domain">
                <!-- Start Domain Info -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('domain_information')
                            <a href="#" class="icon info-modal" data-title="Domain Information" data-xhr-url="/ajax/data/domain"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>
                        @if($whoisData['created_date'] > 0 || $whoisData['updated_date'] > 0 || $whoisData['expired_date'] > 0)
                        <div class="akordiyon-div">
                            <!-- Start Table -->
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <tbody>
                                    @if($whoisData['registrar_name'])
                                    <tr>
                                        <td><b>@language('domain_registrar')</b></td>
                                        <td> {{ Str::upper($whoisData['registrar_name']) }} </td>
                                    </tr>
                                    @endif
                                    @if($whoisData['created_date'] > 0)
                                    <tr>
                                        <td><b>@language('domain_registration_date')</b></td>
                                        <td><span class="mark-green">{{ date('Y-m-d', $whoisData['created_date']) }}</span>	<span class="mark-blue mark-blue-no-bg">{{ elapsed_time($whoisData['created_date']) }} ago</span></td>
                                    </tr>
                                    @endif
                                    @if($whoisData['updated_date'] > 0)
                                        <tr>
                                            <td><b>@language('last_modified')</b></td>
                                            <td><span class="mark-green">{{ date('Y-m-d', $whoisData['updated_date']) }}</span>	<span class="mark-blue mark-blue-no-bg">{{ elapsed_time($whoisData['updated_date']) }} ago</span></td>
                                        </tr>
                                    @endif
                                    @if($whoisData['expired_date'] > 0)
                                    <tr>
                                        <td><b>@language('expiration_date')</b></td>
                                        <td><span class="mark-green">{{ date('Y-m-d', $whoisData['expired_date']) }}</span>	<span class="mark-blue mark-blue-no-bg">@if($whoisData['expired_date'] > time()){{ elapsed_time($whoisData['expired_date'], true) }} from now @else Expired @endif</span></td>
                                    </tr>
                                    @endif
                                    </tbody>
                                </table>
                            </div>
                            <!-- End Table -->
                        </div>
                        @endif

                        @if($whoisData['server_ns_records'])
                            <a href="#" class="akordiyon">@language('domain_nameserver_information')
                                <img src="{{ asset('img/arrow-up.png') }}" alt="icon" class="icon open"></a>
                            <div class="akordiyon-div">
                                <!-- Start Table -->
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead class="tabletitle">
                                        <tr>
                                            <td width="250">@language('host')</td>
                                            <td width="210">@language('ip_address')</td>
                                            <td>@language('country')</td>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($whoisData['server_ns_records'] as $ns)
                                            <tr>
                                                <td>{{ Str::lower($ns['ns']) }}</td>
                                                <td>@if($ns['ip_address']){{ $ns['ip_address'] }}@else - @endif</td>
                                                <td>@if($ns['country_short_name'])<img src="{{ asset('img/flags2/' . $ns['country_short_name'] . '.png') }}" alt="img" class="flag">{{ $ns['country'] }}@else - @endif</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <!-- End Table -->

                            </div>
                        @endif
                    </div>

                </div>
                <!-- End Domain Info -->
            </div>
            @endif

            @if($whoisData['server_ip_address'] && $whoisData['server_country_latitude'] && $whoisData['server_country_longitude'])
            <div class="analyze-group" id="server">
                <!-- Start Server Info -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('website_server_information')
                            <a href="#" class="icon info-modal" data-title="Server Information" data-xhr-url="/ajax/data/server"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <div class="padding-20">
                            <div class="col-md-7"><div id="server-location-map" style="height: 370px;"></div></div>
                            <div class="col-md-5">
                                <ul class="st-list">
                                    @if($whoisData['isp_name'])
                                    <li><b>@language('service_provider')</b></li>
                                    <li>{{ $whoisData['isp_name'] }}</li>
                                    @endif
                                    <li><b>@language('hosted_ip_address')</b></li>
                                    <li>{{ $whoisData['server_ip_address'] }}</li>
                                    <li><b>@language('hosted_country')</b></li>
                                    <li><img src="{{ asset('img/flags2/' . Str::lower($whoisData['server_country_short_name']) . '.png') }}" alt="img" class="flag">{{ $whoisData['server_country_name'] }}</li>
                                    @if($whoisData['server_region'] || $whoisData['server_city'])
                                    <li><b>@language('host_region')</b></li>
                                    <li>@if($whoisData['server_region']){{ $whoisData['server_region'] }}@endif @if($whoisData['server_city']){{ ', '.$whoisData['server_city'] }}@endif</li>
                                    @endif
                                    <li><b>@language('latitude_and_longitude')</b></li>
                                    <li>{{ $whoisData['server_country_latitude']. ' : '. $whoisData['server_country_longitude'] }}</li>
                                </ul>
                            </div>
                            <div class="clear"></div>
                        </div>

                    </div>

                </div>
                <!-- End Server Info -->
            </div>
            @endif


            <div class="analyze-group" id="social">
                <!-- Start SOCIAL -->
                <div class="row">

                    <div class="modul">

                        <div class="titleh">
                            @language('social_networks')
                            <a href="#" class="icon info-modal" data-title="Social Networks" data-xhr-url="/ajax/data/socials"><img src="{{ asset('img/question.png') }}" alt="icon"></a>
                        </div>

                        <!-- Start Table -->
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead class="tabletitle">
                                <tr>
                                    <td>@language('l_social')</td>
                                    <td class="text-r">@language('count')</td>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td><img src="{{ asset('img/facebook-16.png') }}" class="social-icon"/>@language('facebook_total_count')</td>
                                    <td class="text-r">{{ standard_number($socialData['fb_total_count']) }}</td>
                                </tr>
                                <tr>
                                    <td><img src="{{ asset('img/facebook-16.png') }}" class="social-icon"/>@language('facebook_share_count')</td>
                                    <td class="text-r">{{ standard_number($socialData['fb_share_count']) }}</td>
                                </tr>
                                <tr>
                                    <td><img src="{{ asset('img/facebook-16.png') }}" class="social-icon"/>@language('facebook_like_count')</td>
                                    <td class="text-r">{{ standard_number($socialData['fb_like_count']) }}</td>
                                </tr>
                                <tr>
                                    <td><img src="{{ asset('img/facebook-16.png') }}" class="social-icon"/>@language('facebook_comment_count')</td>
                                    <td class="text-r">{{ standard_number($socialData['fb_comment_count']) }}</td>
                                </tr>
                                <tr>
                                    <td><img src="{{ asset('img/facebook-16.png') }}" class="social-icon"/>@language('facebook_comment_box_count')</td>
                                    <td class="text-r">{{ standard_number($socialData['fb_comment_box_count']) }}</td>
                                </tr>
                                <tr>
                                    <td><img src="{{ asset('img/facebook-16.png') }}" class="social-icon"/>@language('facebook_click_count')</td>
                                    <td class="text-r">{{ standard_number($socialData['fb_click_count']) }}</td>
                                </tr>
                                <tr>
                                    <td><img src="{{ asset('img/linkedin-16.png') }}" class="social-icon"/>@language('linkedin_share_count')</td>
                                    <td class="text-r">{{ standard_number($socialData['linkedin_share_count']) }}</td>
                                </tr>
                                <tr>
                                    <td><img src="{{ asset('img/pinterest-16.png') }}" class="social-icon"/>@language('pinterest_share_count')</td>
                                    <td class="text-r">{{ standard_number($socialData['pinterest_share_count']) }}</td>
                                </tr>



                                </tbody>
                            </table>
                        </div>
                        <!-- End Table -->

                    </div>

                </div>
                <!-- End SOCIAL -->
            </div>

            @if(count($adsenseUsedSites) > 1 || count($sameIpAddressSites) > 1 || $cClassIpAddressSites)
            <div class="analyze-group" id="other">

                @if(count($adsenseUsedSites) > 1)
                    <!-- Start Same Adsense -->
                    <div class="row">

                        <div class="modul">

                            <div class="titleh">
                                @language('same_adsense_publisher_id')
                            </div>

                            <!-- Start Table -->
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead class="tabletitle">
                                    <tr>
                                        <td class="favicon-cell"></td>
                                        <td width="450">@language('l_domain')</td>
                                        <td class="text-c" width="120">Pagerank</td>
                                        <td class="text-c" width="130">Alexa Rank</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($adsenseUsedSites as $site)
                                        @if($site['name'] != $name)
                                        <tr>
                                            <td class="favicon-cell"><img src="{{ favicon_url($site['name']) }}" alt="img"></td>
                                            <td><a href="{{ route('site.name', [$site['name']]) }}">{{ $site['name'] }}</a></td>
                                            <td class="text-c">@if($site['google_rank'] >= 0){{ $site['google_rank'] }}@else - @endif</td>
                                            <td class="text-c">@if($site['alexa_rank'] > 0){{ standard_number($site['alexa_rank']) }}@else - @endif</td>
                                        </tr>
                                        @endif
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <!-- End Table -->

                        </div>

                    </div>
                    <!-- End Same Adsense -->
                @endif

                @if(count($sameIpAddressSites) > 1)
                    <!-- Start Same IP -->
                    <div class="row">

                        <div class="modul">

                            <div class="titleh">
                                @language('same_ip_address')
                            </div>

                            <!-- Start Table -->
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead class="tabletitle">
                                    <tr>
                                        <td class="favicon-cell"></td>
                                        <td width="290">@language('l_domain')</td>
                                        <td width="180">IP</td>
                                        <td class="text-c" width="130">Pagerank</td>
                                        <td class="text-c" width="120">Alexa Rank</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($sameIpAddressSites as $site)
                                        @if($site['name'] != $name)
                                        <tr>
                                            <td class="favicon-cell"><img src="{{ favicon_url($site['name']) }}" alt="img"></td>
                                            <td><a href="{{ route('site.name', [$site['name']]) }}">{{ $site['name'] }}</a></td>
                                            <td><img src="{{ asset('img/flags2/' . Str::lower($site['country_code']) . '.png') }}" alt="img" title="{{ $site['country_name'] }}" class="flag">{{ $site['ip_address'] }}</td>
                                            <td class="text-c">@if($site['google_rank'] >= 0){{ $site['google_rank'] }}@else - @endif</td>
                                            <td class="text-c">@if($site['alexa_rank'] > 0){{ standard_number($site['alexa_rank']) }}@else - @endif</td>
                                        </tr>
                                        @endif
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <!-- End Table -->

                        </div>

                    </div>
                    <!-- End Same IP -->
                @endif

                @if($cClassIpAddressSites)
                    <!-- Start Same C Class IP -->
                    <div class="row">

                        <div class="modul">

                            <div class="titleh">
                                @language('same_c_class_ip_address')
                            </div>

                            <!-- Start Table -->
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead class="tabletitle">
                                    <tr>
                                        <td class="favicon-cell"></td>
                                        <td width="290">@language('l_domain')</td>
                                        <td width="180">IP</td>
                                        <td class="text-c" width="130">Pagerank</td>
                                        <td class="text-c" width="120">Alexa Rank</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($cClassIpAddressSites as $site)
                                        <tr>
                                            <td class="favicon-cell"><img src="{{ favicon_url($site['name']) }}" alt="img"></td>
                                            <td><a href="{{ route('site.name', [$site['name']]) }}">{{ $site['name'] }}</a></td>
                                            <td><img src="{{ asset('img/flags2/' . Str::lower($site['country_code']) . '.png') }}" alt="img" title="{{ $site['country_name'] }}" class="flag">{{ $site['ip_address'] }}</td>
                                            <td class="text-c">@if($site['google_rank'] >= 0){{ $site['google_rank'] }}@else - @endif</td>
                                            <td class="text-c">@if($site['alexa_rank'] > 0){{ standard_number($site['alexa_rank']) }}@else - @endif</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <!-- End Table -->

                        </div>

                    </div>
                    <!-- End Same C Class IP -->
                @endif

            </div>
            @endif

        </div>
        <!-- End Content Sol -->

        @include('layouts.partials.sidebar.general')

    </div>
    <!-- End Content -->
    @if($settings->comment_default)
    <!-- Start Comment -->
    <div id="comments" class="container">
        <div class="title">@language('u_comments')
            <span>({{ count($comments) }})</span></div>
        <!-- start left side -->
        <div class="col-md-8">

            @if($comments)
                @foreach($comments as $comment)
                    <div class="get-comment">
                        <img src="{{ get_gravatar($comment['email'], 41) }}" alt="img" class="comment-avatar">
                        <span class="comment-name">{{{ $comment['name'] }}}</span>
                        <span class="comment-date">{{ date('d F Y') }}</span>
                        <div class="comment-div">
                            {{{ $comment['comment'] }}}
                        </div>
                    </div>
                @endforeach
            @endif


            <!-- START FORM -->
            <div class="post-form margin-t-30">
                <h2>@language('post_a_comment')</h2>
                <form action="{{ route('ajax.new-comment') }}">
                    <input type="hidden" name="id" value="{{ $id }}">
                    <input type="text" class="form-control stinput" placeholder="@language('name_lastname')" name="name">
                    <input type="text" class="form-control stinput" placeholder="@language('email')" name="email">
                    <textarea class="form-control stinput" rows="5" placeholder="@language('your_comment')" name="comment"></textarea>

                    <div class="g-recaptcha" data-sitekey="{{ $settings->api_google_recaptcha_site_key }}"></div>

                    <div class="clear"></div>

                    <button id="new-comment-btn" type="submit" class="button" data-text="@language('post_comment')" data-loading-text="@language('please_wait')">@language('post_comment')</button>

                </form>
            </div>
            <!-- END FORM -->
        </div>
        <!-- end left side -->

        <!-- start right side -->
        <div class="col-md-4">
            <div class="margin-t-15">
                @if ($settings->ads_wtp_comments_status == 1)
                    {{ $settings->ads_wtp_comments_code }}
                @endif
            </div>
        </div>
        <!-- end right side -->

    </div>
    <!-- End Comment -->
    @endif

    @if($settings->comment_facebook)
        <!-- Start Comment -->
        <div id="comments" class="container">
            <div class="title">FACEBOOK @language('u_comments')</div>
            <!-- start left side -->
            <div class="col-md-8">

                <div id="fb-root"></div>
                <script>(function(d, s, id) {
                        var js, fjs = d.getElementsByTagName(s)[0];
                        if (d.getElementById(id)) return;
                        js = d.createElement(s); js.id = id;
                        js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.5&appId={{ $settings->api_facebook_app_id }}";
                        fjs.parentNode.insertBefore(js, fjs);
                    }(document, 'script', 'facebook-jssdk'));</script>

                <div class="fb-comments" data-href="{{ route('site.name', [$name]) }}" data-numposts="{{ $settings->comment_facebook_limit }}"></div>

            </div>
            <!-- end left side -->

            <!-- start right side -->
            <div class="col-md-4">
                <div class="margin-t-15">
                    @if ($settings->ads_wtp_fb_comments_status == 1)
                        {{ $settings->ads_wtp_fb_comments_code }}
                    @endif
                </div>
            </div>
            <!-- end right side -->

        </div>
        <!-- End Comment -->
    @endif

    @if($settings->comment_disqus)
        <!-- Start Comment -->
        <div id="comments" class="container">
            <div class="title">DISQUS @language('u_comments')</div>
            <!-- start left side -->
            <div class="col-md-12">
                <div id="disqus_thread"></div>
                <script type="text/javascript">
                    var disqus_shortname = '{{ $settings->comment_disqus_username }}';
                    (function() {
                    var dsq = document.createElement('script'); dsq.type = 'text/javascript'; dsq.async = true;
                    dsq.src = '//' + disqus_shortname + '.disqus.com/embed.js';
                    (document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(dsq);
                    })();
                </script>
            </div>
            <!-- end left side -->

        </div>
        <!-- End Comment -->
    @endif

@stop

