@extends('layouts.master')

@section('metas')
    <title>Countries - {{ $settings->site_name }}</title>
    <meta name="description" content="The webpage that displays registered countries on {{ $settings->site_name }}."/>
    <meta name="keywords" content="countries, country"/>
@stop

@section('content')

    <div class="container">
        <ol class="breadcrumb">
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="{{ route('index') }}" itemprop="url"><span itemprop="title">@language('home')</span></a></li>
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb" itemprop="child" class="active"><a href="{{ route('site.country') }}" itemprop="url"><span itemprop="title">@language('countries')</span></a></li>
        </ol>
    </div>

    <!-- Start Content -->
    <div class="container content">

        <!-- Start Content Sol -->
        <div class="content-sol col-md-8">

            <div class="main-ads">
                @if ($settings->ads_ap_header_status == 1)
                    {{ $settings->ads_ap_header_code }}
                @endif
            </div>

            <h1 class="st-h1">@language('countries')</h1>
            <p class="padding-t-10 main-p">
				@language('countries_desc')
            </p>

            <div class="float-l half-ads" style="width: 352px; height: 280px;">
                @if ($settings->ads_cp_status == 1)
                    {{ $settings->ads_cp_code }}
                @endif
            </div>

            <table class="table table-striped float-r half-table">
                <tbody>
                @foreach($partial1 as $country)
                    <tr>
                        <td><strong>{{ $index++ }}</strong></td>
                        <td><a href="{{ route('site.country-websites', [$country['slug']]) }}" title="{{ $country['name'] }}"><img src="{{ asset('img/flags2/' . $country['alpha_2'] . '.png') }}" alt="img" class="flag">{{ Str::limit($country['name'], 15) }}</a></td>
                        <td class="text-r">{{ standard_number($country['website_count']) }} sites</td>
                    </tr>
                @endforeach

                </tbody>
            </table>

            <div class="clearfix margin-b-20"></div>
            @if($partial2)
                <table class="table table-striped float-l half-table">
                    <tbody>
                    @foreach($partial2 as $country)
                        <tr>
                            <td><strong>{{ $index++ }}</strong></td>
                            <td><a href="{{ route('site.country-websites', [$country['slug']]) }}" title="{{ $country['name'] }}"><img src="{{ asset('img/flags2/' . $country['alpha_2'] . '.png') }}" alt="img" class="flag">{{ Str::limit($country['name'], 15) }}</a></td>
                            <td class="text-r">{{ standard_number($country['website_count']) }} sites</td>
                        </tr>
                    @endforeach

                    </tbody>
                </table>
            @endif

            @if($partial3)
                <table class="table table-striped float-l half-table">
                    <tbody>

                    @foreach($partial3 as $country)
                        <tr>
                            <td><strong>{{ $index++ }}</strong></td>
                            <td><a href="{{ route('site.country-websites', [$country['slug']]) }}" title="{{ $country['name'] }}"><img src="{{ asset('img/flags2/' . $country['alpha_2'] . '.png') }}" alt="img" class="flag">{{ Str::limit($country['name'], 15) }}</a></td>
                            <td class="text-r">{{ standard_number($country['website_count']) }} sites</td>
                        </tr>
                    @endforeach

                    </tbody>
                </table>
            @endif


        </div>
        <!-- End Content Sol -->

        @include('layouts.partials.sidebar.general')

    </div>
    <!-- End Content -->

@stop