@extends('layouts.master')

@section('metas')
    <title>Contact - {{ $settings->site_name }}</title>
    <meta name="description" content="Page to contact {{ $settings->site_name }} team."/>
    <meta name="keywords" content="contact, contact form"/>
@stop

@section('scripts')
    <script type="text/javascript" src='http://www.google.com/recaptcha/api.js'></script>
    <script type="text/javascript" src="{{ asset('js/contact.js') }}"></script>
@stop

@section('content')


    <div class="container">
        <ol class="breadcrumb">
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="{{ route('index') }}" itemprop="url"><span itemprop="title">@language('home')</span></a></li>
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb" itemprop="child" class="active"><a href="{{ route('site.contact') }}" itemprop="url"><span itemprop="title">@language('contact')</span></a></li>
        </ol>
    </div>

    <!-- Start Content -->
    <div class="container content">

        <!-- Start Content Sol -->
        <div class="content-sol col-md-8">

            <div class="main-ads">
                @if ($settings->ads_ap_header_status == 1)
                    {{ $settings->ads_ap_header_code }}
                @endif
            </div>

            <h1 class="st-h1">@language('contact_title')</h1>
            <p class="padding-t-10 main-p">
                @language('contact_desc')
            </p>
			<strong>@language('important')</strong> :
			<a href="#" class="remove-my-website" data-title="@language('remove_website')" data-desc="@language('remove_website_message_title')" data-ajax-url="{{ route('ajax.remove-site') }}"><strong>@language('remove_website_message')</strong></a>
            <!-- START FORM -->
            <div class="post-form margin-t-30">
                <h2>@language('contact_form')</h2>
                <form action="{{ route('ajax.contact') }}">
                    <input type="text" name="name" class="form-control stinput" placeholder="@language('name_lastname')">
                    <input type="text" name="email" class="form-control stinput" placeholder="@language('email')">
                    <input type="text" name="subject" class="form-control stinput" placeholder="@language('subject')">
                    <textarea name="message" class="form-control stinput" rows="5" placeholder="@language('your_message')"></textarea>

                    <div class="g-recaptcha" data-sitekey="{{ $settings->api_google_recaptcha_site_key }}"></div>

                    <div class="clear"></div>

                    <button id="send-me" type="submit" class="button" data-text="@language('send_form')" data-loading-text="@language('please_wait')">@language('send_form')</button>

                </form>
            </div>
            <!-- END FORM -->

        </div>
        <!-- End Content Sol -->

        @include('layouts.partials.sidebar.general')

    </div>
    <!-- End Content -->

@stop