@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Add New Words @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Add New Words</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ route('word.filter.all') }}">Word List</a></li>
            <li class="active">Add New Words</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">
                <!-- form start -->
                <form action="{{ route('ajax.create.filter.word') }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <!-- Filter Words -->
                    <div class="form-group">
                      <label for="filter_words" class="col-sm-2 control-label">Filter Words</label>
                      <div class="col-sm-10">
                        <input type="text" name="filter_words" class="input-tags">
                      </div>
                    </div>

                    <div class="form-group form-actions">
                      <div class="col-sm-10 col-sm-offset-2">
                        <button type="submit" id="add" class="btn btn-info">ADD</button>
                      </div>
                    </div>

                  </div><!-- /.box-body -->

                </form>
              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/word-filter.js') }}"></script>
@stop