@extends('admin.layouts.master')

@section('title') Edit Website - {{ $website->name }} @stop


@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>Edit Website</h1>
        <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ route('website.list') }}">Website List</a></li>
            <li class="active">{{ $website->name }}</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- right column -->
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box">
                    <!-- form start -->
                    <form action="{{ route('ajax.update.website', [$website->id]) }}" name="edit" class="form-horizontal form-bordered">
                        <div class="box-body">
                            <!-- Website Screenshot -->
                            <div class="form-group">
                                <label for="slug" class="col-sm-2 control-label">Website Screenshot</label>
                                <div class="col-sm-3">
                                    @if (File::exists(public_path('screenshots/'. md5($website->name) .'.png')))
                                        <img src="{{ asset('screenshots/'. md5($website->name) .'.png') }}" class="img-thumbnail" id="website-screenshot" width="100%" alt="{{ $website->name }}" />
                                    @else
                                        <img src="{{ asset('img/default-screenshot.png') }}" class="img-thumbnail" width="100%" alt="{{ $website->name }}" />
                                    @endif

                                    @if (File::exists(public_path('screenshots/'. md5($website->name) .'.png')))
                                        <a href="{{ route('ajax.remove.website.screenshot', md5($website->name)) }}" class="btn btn-danger btn-xs margin-t-5" id="remove-screenshot">Remove Screenshot</a>
                                    @endif
                                </div>
                            </div>

                            <!-- Website -->
                            <div class="form-group">
                                <label for="slug" class="col-sm-2 control-label">Website</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" value="{{ $website->name }}" disabled>
                                </div>
                            </div>

                            <!-- Website Title -->
                            <div class="form-group">
                                <label for="slug" class="col-sm-2 control-label">Website Title</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="title" placeholder="Enter the website title..." value="{{ $website->site_title }}">
                                </div>
                            </div>

                            <!-- Website Keywords -->
                            <div class="form-group">
                                <label for="keywords" class="col-sm-2 control-label">Website Keywords</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="keywords" placeholder="Enter the website keywords..." value="{{ $website->site_keywords }}">
                                </div>
                            </div>

                            <!-- Website Description -->
                            <div class="form-group">
                                <label for="description" class="col-sm-2 control-label">Website Description</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" name="description" placeholder="Enter the website description...">{{ $website->site_description }}</textarea>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="country-code" class="col-sm-2 control-label">Country</label>
                                <div class="col-sm-10">
                                    <select name="country" class="form-control">
                                        @foreach($countries as $country)
                                            <option value="{{ $country->id }}" @if($country->name == $website->country_name) selected @endif>{{ Str::upper($country->alpha_2) . ' - ' .$country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="ip-address" class="col-sm-2 control-label">IP Address</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="ip" value="{{ $website->ip_address }}">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="ip-address" class="col-sm-2 control-label">Created Time</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" value="{{ $website->created_at }}" disabled>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="ip-address" class="col-sm-2 control-label">Updated Time</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" value="{{ $website->updated_at }}" disabled>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="ip-address" class="col-sm-2 control-label">Last Analyzed Time</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" value="{{ $website->analyzed_at }}" disabled>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="status" class="col-sm-2 control-label">Analyze Status</label>
                                <div class="col-sm-10">
                                    <input type="checkbox" class="switch" disabled @if($website->status == 1) checked @endif data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="status" class="col-sm-2 control-label">Publication Status</label>
                                <div class="col-sm-10">
                                    @if($website->status == 1)
                                        <input type="checkbox" name="publish" class="switch" @if($website->publish == 1) checked @endif data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small">
                                    @else
                                        <input type="checkbox" name="publish" class="switch" disabled @if($website->publish == 1) checked @endif data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small">
                                    @endif
                                </div>
                            </div>

                            <div class="form-group form-actions">
                                <div class="col-sm-10 col-sm-offset-2">
                                    <button type="button" id="update" class="btn btn-info">UPDATE</button>
                                </div>
                            </div>

                        </div><!-- /.box-body -->

                    </form>
                </div><!-- /.box -->

            </div><!--/.col (right) -->
        </div>   <!-- /.row -->
    </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/websites.js') }}"></script>
@stop