@extends('admin.layouts.master')

@section('title') Deletion Requests @stop

@section('content')

    <section class="content-header">
        <h1>
            Deletion Requests
            <small>preview of requests</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Deletion Requests</li>
        </ol>
    </section>
    <section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-body">

                    <div class="row">
                        <div class="col-sm-12">
                            <table id="websites" data-ajax-url="{{ route('ajax.get.deletion') }}" class="table table-bordered table-striped" cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                    <th>#ID</th>
                                    <th>Website</th>
                                    <th>Verify Type</th>
                                    <th>IP Address</th>
                                    <th>Request Time</th>
                                    <th>Verify Time</th>
                                    <th>Status</th>
                                    @if ($settings->after_a_website_verifying == 1)
                                    <th>Options</th>
                                    @endif
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div><!-- /.box-body -->


            </div><!-- /.box -->
        </div>
    </div>
    </section>

@stop
@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/websites.js') }}"></script>
@stop