@extends('admin.layouts.master')

@section('title') Bulk Upload @stop


@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>Bulk Upload</h1>
        <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Bulk Upload</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- right column -->
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box">
                    <!-- form start -->
                    <form action="{{ route('ajax.bulk.website.create') }}" name="edit" class="form-horizontal form-bordered">
                        <div class="box-body">
                            <!-- Website List-->
                            <div class="form-group">
                                <label for="keywords" class="col-sm-2 control-label">Website List</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" name="website_list" rows="10" placeholder="Enter one address per line site..."></textarea>
                                </div>
                            </div>

                            <div class="form-group form-actions">
                                <div class="col-sm-10 col-sm-offset-2">
                                    <button type="button" id="bulkUpload" class="btn btn-info"><i class="fa fa-upload margin-r-5"></i>UPLOAD</button>
                                </div>
                            </div>

                        </div><!-- /.box-body -->

                    </form>
                </div><!-- /.box -->

            </div><!--/.col (right) -->
        </div>   <!-- /.row -->
    </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/websites.js') }}"></script>
@stop