@extends('admin.layouts.master')

@section('title') Website List @stop

@section('content')

    <section class="content-header">
        <h1>
            Website List
            <small>preview of websites</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Website List</li>
        </ol>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-body">

                            <div class="row">
                                <div class="col-sm-12">

                                    <table id="websites" data-ajax-url="{{ route('ajax.get.website') }}" class="table table-bordered table-striped" cellspacing="0" width="100%">
                                        <thead>
                                        <tr>
                                            <th>#ID</th>
                                            <th>Website</th>
                                            <th>Country</th>
                                            <th>IP Address</th>
                                            <th>Created Time</th>
                                            <th>Status</th>
                                            <th>Publish</th>
                                            <th>Options</th>
                                        </tr>
                                        </thead>
                                    </table>

                                    </div>
                            </div>
                        </div><!-- /.box-body -->
                </div>
            </div>
        </div>
    </section>

@stop
@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/websites.js') }}"></script>
@stop