@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Social Media Settings @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Social Media Settings</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Social Media Settings</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">

                <!-- form start -->
                <form action="{{ route('ajax.update.social.settings', [1]) }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <div class="box-header with-border form-title">Social Sharing</div>
                    <div class="col-sm-6">
                        <!-- Facebook -->
                        <div class="form-group">
                          <label for="facebook" class="col-sm-5 control-label margin-t-n-4"> Facebook <span class="btn btn-social-icon btn-facebook margin-l-10"><i class="fa fa-facebook"></i></span></label>
                          <div class="col-sm-7">
                            <input type="checkbox" name="facebook" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->share_facebook == 1) checked @endif>
                          </div>
                        </div>

                        <!-- Twitter -->
                        <div class="form-group">
                          <label for="twitter" class="col-sm-5 control-label margin-t-n-4"> Twitter <span class="btn btn-social-icon btn-twitter margin-l-10"><i class="fa fa-twitter"></i></span></label>
                          <div class="col-sm-7">
                            <input type="checkbox" name="twitter" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->share_twitter == 1) checked @endif>
                          </div>
                        </div>

                        <!-- Google Plus -->
                        <div class="form-group">
                          <label for="google_plus" class="col-sm-5 control-label margin-t-n-4"> Google Plus <span class="btn btn-social-icon btn-google margin-l-10"><i class="fa fa-google-plus"></i></span></label>
                          <div class="col-sm-7">
                            <input type="checkbox" name="google_plus" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->share_google_plus == 1) checked @endif>
                          </div>
                        </div>

                        <!-- Delicious -->
                        <div class="form-group">
                          <label for="delicious" class="col-sm-5 control-label margin-t-n-4"> Delicious <span class="btn btn-social-icon btn-delicious margin-l-10"><i class="fa fa-delicious"></i></span></label>
                          <div class="col-sm-7">
                            <input type="checkbox" name="delicious" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->share_delicious == 1) checked @endif>
                          </div>
                        </div>

                        <!-- Stumbleupon -->
                        <div class="form-group">
                          <label for="stumbleupon" class="col-sm-5 control-label margin-t-n-4"> Stumbleupon <span class="btn btn-social-icon btn-stumbleupon margin-l-10"><i class="fa fa-stumbleupon"></i></span></label>
                          <div class="col-sm-7">
                            <input type="checkbox" name="stumbleupon" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->share_stumbleupon == 1) checked @endif>
                          </div>
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <!-- Tumblr -->
                        <div class="form-group">
                          <label for="tumblr" class="col-sm-5 control-label margin-t-n-4"> Tumblr <span class="btn btn-social-icon btn-tumblr margin-l-10"><i class="fa fa-tumblr"></i></span></label>
                          <div class="col-sm-7">
                            <input type="checkbox" name="tumblr" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->share_tumblr == 1) checked @endif>
                          </div>
                        </div>

                        <!-- Linkedin -->
                        <div class="form-group">
                          <label for="linkedin" class="col-sm-5 control-label margin-t-n-4"> Linkedin <span class="btn btn-social-icon btn-linkedin margin-l-10"><i class="fa fa-linkedin"></i></span></label>
                          <div class="col-sm-7">
                            <input type="checkbox" name="linkedin" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->share_linkedin == 1) checked @endif>
                          </div>
                        </div>

                        <!-- Pinterest -->
                        <div class="form-group">
                          <label for="pinterest" class="col-sm-5 control-label margin-t-n-4"> Pinterest <span class="btn btn-social-icon btn-pinterest margin-l-10"><i class="fa fa-pinterest"></i></span></label>
                          <div class="col-sm-7">
                            <input type="checkbox" name="pinterest" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->share_pinterest == 1) checked @endif>
                          </div>
                        </div>

                        <!-- Reddit -->
                        <div class="form-group">
                          <label for="reddit" class="col-sm-5 control-label margin-t-n-4"> Reddit <span class="btn btn-social-icon btn-reddit margin-l-10"><i class="fa fa-reddit"></i></span></label>
                          <div class="col-sm-7">
                            <input type="checkbox" name="reddit" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->share_reddit == 1) checked @endif>
                          </div>
                        </div>

                        <!-- Digg -->
                        <div class="form-group">
                          <label for="digg" class="col-sm-5 control-label margin-t-n-4"> Digg <span class="btn btn-social-icon btn-digg margin-l-10"><i class="fa fa-digg"></i></span></label>
                          <div class="col-sm-7">
                            <input type="checkbox" name="digg" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->share_digg == 1) checked @endif>
                          </div>
                        </div>
                    </div>

                    <div class="box-header with-border form-title clear">Social Accounts</div>

                    <div class="col-sm-6">
                        <!-- Facebook -->
                        <div class="form-group">
                          <label for="facebook_account_status" class="col-sm-5 control-label margin-t-n-4"> Facebook <span class="btn btn-social-icon btn-facebook margin-l-10"><i class="fa fa-facebook"></i></span></label>
                          <div class="col-sm-7">
                            <input type="text" class="form-control" name="facebook_account" placeholder="Enter the Facebook account..." value="{{ $settings->social_facebook_a }}">
                          </div>
                        </div>

                        <!-- Twitter -->
                        <div class="form-group">
                          <label for="twitter_account_status" class="col-sm-5 control-label margin-t-n-4"> Twitter <span class="btn btn-social-icon btn-twitter margin-l-10"><i class="fa fa-twitter"></i></span></label>
                          <div class="col-sm-7">
                            <input type="text" class="form-control" name="twitter_account" placeholder="Enter the Twitter account..." value="{{ $settings->social_twitter_a }}">
                          </div>
                        </div>

                        <!-- Google Plus -->
                        <div class="form-group">
                          <label for="google_plus_account_status" class="col-sm-5 control-label margin-t-n-4"> Google Plus <span class="btn btn-social-icon btn-google margin-l-10"><i class="fa fa-google-plus"></i></span></label>
                          <div class="col-sm-7">
                            <input type="text" class="form-control" name="google_plus_account" placeholder="Enter the Google Plus account..." value="{{ $settings->social_google_plus_a }}">
                          </div>
                        </div>

                        <!-- Delicious -->
                        <div class="form-group">
                          <label for="delicious_account_status" class="col-sm-5 control-label margin-t-n-4"> Delicious <span class="btn btn-social-icon btn-delicious margin-l-10"><i class="fa fa-delicious"></i></span></label>
                          <div class="col-sm-7">
                            <input type="text" class="form-control" name="delicious_account" placeholder="Enter the Delicious account..." value="{{ $settings->social_delicious_a }}">
                          </div>
                        </div>

                        <!-- Stumbleupon -->
                        <div class="form-group">
                          <label for="stumbleupon_account_status" class="col-sm-5 control-label margin-t-n-4"> Stumbleupon <span class="btn btn-social-icon btn-stumbleupon margin-l-10"><i class="fa fa-stumbleupon"></i></span></label>
                          <div class="col-sm-7">
                            <input type="text" class="form-control" name="stumbleupon_account" placeholder="Enter the Stumbleupon account..." value="{{ $settings->social_stumbleupon_a }}">
                          </div>
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <!-- Tumblr -->
                        <div class="form-group">
                          <label for="tumblr_account_status" class="col-sm-5 control-label margin-t-n-4"> Tumblr <span class="btn btn-social-icon btn-tumblr margin-l-10"><i class="fa fa-tumblr"></i></span></label>
                          <div class="col-sm-7">
                            <input type="text" class="form-control" name="tumblr_account" placeholder="Enter the Tumblr account..." value="{{ $settings->social_tumblr_a }}">
                          </div>
                        </div>

                        <!-- Linkedin -->
                        <div class="form-group">
                          <label for="linkedin_account_status" class="col-sm-5 control-label margin-t-n-4"> Linkedin <span class="btn btn-social-icon btn-linkedin margin-l-10"><i class="fa fa-linkedin"></i></span></label>
                          <div class="col-sm-7">
                            <input type="text" class="form-control" name="linkedin_account" placeholder="Enter the Linkedin account..." value="{{ $settings->social_linkedin_a }}">
                          </div>
                        </div>

                        <!-- Pinterest -->
                        <div class="form-group">
                          <label for="pinterest_account_status" class="col-sm-5 control-label margin-t-n-4"> Pinterest <span class="btn btn-social-icon btn-pinterest margin-l-10"><i class="fa fa-pinterest"></i></span></label>
                          <div class="col-sm-7">
                            <input type="text" class="form-control" name="pinterest_account" placeholder="Enter the Pinterest account..." value="{{ $settings->social_pinterest_a }}">
                          </div>
                        </div>

                        <!-- Reddit -->
                        <div class="form-group">
                          <label for="reddit_account_status" class="col-sm-5 control-label margin-t-n-4"> Reddit <span class="btn btn-social-icon btn-reddit margin-l-10"><i class="fa fa-reddit"></i></span></label>
                          <div class="col-sm-7">
                            <input type="text" class="form-control" name="reddit_account" placeholder="Enter the Reddit account..." value="{{ $settings->social_reddit_a }}">
                          </div>
                        </div>

                        <!-- Digg -->
                        <div class="form-group">
                          <label for="digg_account_status" class="col-sm-5 control-label margin-t-n-4"> Digg <span class="btn btn-social-icon btn-digg margin-l-10"><i class="fa fa-digg"></i></span></label>
                          <div class="col-sm-7">
                            <input type="text" class="form-control" name="digg_account" placeholder="Enter the Digg account..." value="{{ $settings->social_digg_a }}">
                          </div>
                        </div>
                    </div>

                    <div class="col-sm-12">
                        <div class="form-group form-actions">
                            <button type="submit" id="socialUpdate" class="btn btn-info float-r">UPDATE</button>
                        </div>
                    </div>

                  </div><!-- /.box-body -->

                </form>
              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/setting.js') }}"></script>
@stop