@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Sitemap Settings @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Sitemap Settings</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Sitemap Settings</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">
                <!-- form start -->
                <form action="{{ route('ajax.update.sitemap.settings', [1]) }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <!-- Website Count Per Page -->
                    <div class="form-group">
                      <label for="sitemap_per_page" class="col-sm-2 control-label">Website Per Page</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" name="sitemap_per_page" placeholder="Enter the website count per page..." value="{{ $sitemap->sitemap_per_page }}">
                      </div>
                    </div>

                    <div class="box-header with-border form-title">
                      Hangi bölümlerin sitemap'a dahil olacağını seçiniz.
                    </div>

                    <!-- Page -->
                    <div class="form-group">
                      <label for="page_status" class="col-sm-2 control-label">Page</label>
                      <div class="col-sm-10">
                        <input type="checkbox" name="page_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($sitemap->page_status == 1) checked @endif>
                        <span class="margin-l-10">Sayfaları dahil edin.</span>
                      </div>
                    </div>

                    <!-- Country -->
                    <div class="form-group">
                      <label for="country_status" class="col-sm-2 control-label">Country</label>
                      <div class="col-sm-10">
                        <input type="checkbox" name="country_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($sitemap->country_status == 1) checked @endif>
                        <span class="margin-l-10">Ülkeleri dahil edin.</span>
                      </div>
                    </div>

                    <!-- Website -->
                    <div class="form-group">
                      <label for="website_status" class="col-sm-2 control-label">Website</label>
                      <div class="col-sm-10">
                        <input type="checkbox" name="website_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($sitemap->website_status == 1) checked @endif>
                        <span class="margin-l-10">Websitelerini dahil edin.</span>
                      </div>
                    </div>

                    <!-- Page Options -->
                    <div class="box-header with-border form-title">
                      Page
                    </div>

                    <!-- Page Change Frequency -->
                    <div class="form-group">
                      <label for="page_change_frequency" class="col-sm-2 control-label">Change Frequency</label>
                      <div class="col-sm-10">
                        <select name="page_change_frequency" class="form-control">
                            <option value="always" @if ($sitemap->page_change_frequency == 'always') selected @endif>Always</option>
                            <option value="hourly" @if ($sitemap->page_change_frequency == 'hourly') selected @endif>Hourly</option>
                            <option value="daily" @if ($sitemap->page_change_frequency == 'daily') selected @endif>Daily</option>
                            <option value="weekly" @if ($sitemap->page_change_frequency == 'weekly') selected @endif>Weekly</option>
                            <option value="monthly" @if ($sitemap->page_change_frequency == 'monthly') selected @endif>Monthly</option>
                            <option value="yearly" @if ($sitemap->page_change_frequency == 'yearly') selected @endif>Yearly</option>
                            <option value="never" @if ($sitemap->page_change_frequency == 'never') selected @endif>Never</option>
                        </select>
                      </div>
                    </div>

                    <!-- Page Priority Level -->
                    <div class="form-group">
                      <label for="page_priority_level" class="col-sm-2 control-label">Priority Level</label>
                      <div class="col-sm-10">
                        <select name="page_priority_level" class="form-control">
                            <option value="1.0" @if ($sitemap->page_priority_level == '1.0') selected @endif>1.0</option>
                            <option value="0.9" @if ($sitemap->page_priority_level == '0.9') selected @endif>0.9</option>
                            <option value="0.8" @if ($sitemap->page_priority_level == '0.8') selected @endif>0.8</option>
                            <option value="0.7" @if ($sitemap->page_priority_level == '0.7') selected @endif>0.7</option>
                            <option value="0.6" @if ($sitemap->page_priority_level == '0.6') selected @endif>0.6</option>
                            <option value="0.5" @if ($sitemap->page_priority_level == '0.5') selected @endif>0.5</option>
                            <option value="0.4" @if ($sitemap->page_priority_level == '0.4') selected @endif>0.4</option>
                            <option value="0.3" @if ($sitemap->page_priority_level == '0.3') selected @endif>0.3</option>
                            <option value="0.2" @if ($sitemap->page_priority_level == '0.2') selected @endif>0.2</option>
                            <option value="0.1" @if ($sitemap->page_priority_level == '0.1') selected @endif>0.1</option>
                            <option value="0.0" @if ($sitemap->page_priority_level == '0.0') selected @endif>0.0</option>
                        </select>
                      </div>
                    </div>

                    <!-- Country Options -->
                    <div class="box-header with-border form-title">
                      Country
                    </div>

                    <!-- Country Change Frequency -->
                    <div class="form-group">
                      <label for="country_change_frequency" class="col-sm-2 control-label">Change Frequency</label>
                      <div class="col-sm-10">
                        <select name="country_change_frequency" class="form-control">
                            <option value="always" @if ($sitemap->country_change_frequency == 'always') selected @endif>Always</option>
                            <option value="hourly" @if ($sitemap->country_change_frequency == 'hourly') selected @endif>Hourly</option>
                            <option value="daily" @if ($sitemap->country_change_frequency == 'daily') selected @endif>Daily</option>
                            <option value="weekly" @if ($sitemap->country_change_frequency == 'weekly') selected @endif>Weekly</option>
                            <option value="monthly" @if ($sitemap->country_change_frequency == 'monthly') selected @endif>Monthly</option>
                            <option value="yearly" @if ($sitemap->country_change_frequency == 'yearly') selected @endif>Yearly</option>
                            <option value="never" @if ($sitemap->country_change_frequency == 'never') selected @endif>Never</option>
                        </select>
                      </div>
                    </div>

                    <!-- Country Priority Level -->
                    <div class="form-group">
                      <label for="country_priority_level" class="col-sm-2 control-label">Priority Level</label>
                      <div class="col-sm-10">
                        <select name="country_priority_level" class="form-control">
                            <option value="1.0" @if ($sitemap->country_priority_level == '1.0') selected @endif>1.0</option>
                            <option value="0.9" @if ($sitemap->country_priority_level == '0.9') selected @endif>0.9</option>
                            <option value="0.8" @if ($sitemap->country_priority_level == '0.8') selected @endif>0.8</option>
                            <option value="0.7" @if ($sitemap->country_priority_level == '0.7') selected @endif>0.7</option>
                            <option value="0.6" @if ($sitemap->country_priority_level == '0.6') selected @endif>0.6</option>
                            <option value="0.5" @if ($sitemap->country_priority_level == '0.5') selected @endif>0.5</option>
                            <option value="0.4" @if ($sitemap->country_priority_level == '0.4') selected @endif>0.4</option>
                            <option value="0.3" @if ($sitemap->country_priority_level == '0.3') selected @endif>0.3</option>
                            <option value="0.2" @if ($sitemap->country_priority_level == '0.2') selected @endif>0.2</option>
                            <option value="0.1" @if ($sitemap->country_priority_level == '0.1') selected @endif>0.1</option>
                            <option value="0.0" @if ($sitemap->country_priority_level == '0.0') selected @endif>0.0</option>
                        </select>
                      </div>
                    </div>

                    <!-- Website Options -->
                    <div class="box-header with-border form-title">
                      Website
                    </div>

                    <!-- Website Change Frequency -->
                    <div class="form-group">
                      <label for="website_change_frequency" class="col-sm-2 control-label">Change Frequency</label>
                      <div class="col-sm-10">
                        <select name="website_change_frequency" class="form-control">
                            <option value="always" @if ($sitemap->website_change_frequency == 'always') selected @endif>Always</option>
                            <option value="hourly" @if ($sitemap->website_change_frequency == 'hourly') selected @endif>Hourly</option>
                            <option value="daily" @if ($sitemap->website_change_frequency == 'daily') selected @endif>Daily</option>
                            <option value="weekly" @if ($sitemap->website_change_frequency == 'weekly') selected @endif>Weekly</option>
                            <option value="monthly" @if ($sitemap->website_change_frequency == 'monthly') selected @endif>Monthly</option>
                            <option value="yearly" @if ($sitemap->website_change_frequency == 'yearly') selected @endif>Yearly</option>
                            <option value="never" @if ($sitemap->website_change_frequency == 'never') selected @endif>Never</option>
                        </select>
                      </div>
                    </div>

                    <!-- Website Priority Level -->
                    <div class="form-group">
                      <label for="website_priority_level" class="col-sm-2 control-label">Priority Level</label>
                      <div class="col-sm-10">
                        <select name="website_priority_level" class="form-control">
                            <option value="1.0" @if ($sitemap->website_priority_level == '1.0') selected @endif>1.0</option>
                            <option value="0.9" @if ($sitemap->website_priority_level == '0.9') selected @endif>0.9</option>
                            <option value="0.8" @if ($sitemap->website_priority_level == '0.8') selected @endif>0.8</option>
                            <option value="0.7" @if ($sitemap->website_priority_level == '0.7') selected @endif>0.7</option>
                            <option value="0.6" @if ($sitemap->website_priority_level == '0.6') selected @endif>0.6</option>
                            <option value="0.5" @if ($sitemap->website_priority_level == '0.5') selected @endif>0.5</option>
                            <option value="0.4" @if ($sitemap->website_priority_level == '0.4') selected @endif>0.4</option>
                            <option value="0.3" @if ($sitemap->website_priority_level == '0.3') selected @endif>0.3</option>
                            <option value="0.2" @if ($sitemap->website_priority_level == '0.2') selected @endif>0.2</option>
                            <option value="0.1" @if ($sitemap->website_priority_level == '0.1') selected @endif>0.1</option>
                            <option value="0.0" @if ($sitemap->website_priority_level == '0.0') selected @endif>0.0</option>
                        </select>
                      </div>
                    </div>

                    <div class="form-group form-actions">
                      <div class="col-sm-10 col-sm-offset-2">
                        <button type="submit" id="sitemapUpdate" class="btn btn-info">UPDATE</button>
                      </div>
                    </div>

                  </div><!-- /.box-body -->

                </form>
              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/setting.js') }}"></script>
@stop