@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Pagination Settings @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Pagination Settings</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Pagination Settings</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">
                <!-- form start -->
                <form action="{{ route('ajax.update.pagination.settings', [1]) }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <div class="box-header with-border form-title">Home Page</div>

                    <!-- Recently Added Websites Limit -->
                    <div class="form-group">
                      <label for="recently_websites_limit" class="col-sm-3 control-label">Recently Added Websites Limit</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="recently_websites_limit" placeholder="Enter the recently added websites limit..." value="{{ $settings->recently_websites_limit }}">
                      </div>
                    </div>

                    <!-- Countries Limit -->
                    <div class="form-group">
                      <label for="countries_limit" class="col-sm-3 control-label">Countries Limit</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="countries_limit" placeholder="Enter the website countries limit..." value="{{ $settings->countries_limit }}">
                      </div>
                    </div>

                    <div class="box-header with-border form-title">Website Detail Page</div>

                    <!-- Table Row Limit -->
                    <div class="form-group">
                      <label for="table_row_limit" class="col-sm-3 control-label">Table Row Limit</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="table_row_limit" placeholder="Enter the table row limit..." value="{{ $settings->table_row_limit }}">
                      </div>
                    </div>

                    <!-- Link Limit (Link Analysis) -->
                    <div class="form-group">
                      <label for="link_limit" class="col-sm-3 control-label">Link Limit (Link Analysis)</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="link_limit" placeholder="Enter the link limit..." value="{{ $settings->link_limit }}">
                      </div>
                    </div>

                    <div class="box-header with-border form-title">Country Page</div>

                    <!-- Website Per Country Page -->
                    <div class="form-group">
                      <label for="website_per_country_page" class="col-sm-3 control-label">Website Per Country Page</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="website_per_country_page" placeholder="Enter the website count per page..." value="{{ $settings->website_per_country_page }}">
                      </div>
                    </div>

                    <div class="box-header with-border form-title">Sidebar</div>

                    <!-- Sidebar Countries Limit -->
                    <div class="form-group">
                      <label for="sidebar_countries_limit" class="col-sm-3 control-label">Countries Limit</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="sidebar_countries_limit" placeholder="Enter the countries limit..." value="{{ $settings->sidebar_countries_limit }}">
                      </div>
                    </div>

                    <!-- Sidebar Analyzed Websites Limit -->
                    <div class="form-group">
                      <label for="sidebar_analyzed_websites_limit" class="col-sm-3 control-label">Analyzed Websites Limit</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="sidebar_analyzed_websites_limit" placeholder="Enter the analyzed websites limit..." value="{{ $settings->sidebar_analyzed_websites_limit }}">
                      </div>
                    </div>

                    <div class="form-group form-actions">
                      <div class="col-sm-9 col-sm-offset-3">
                        <button type="submit" id="paginationUpdate" class="btn btn-info">UPDATE</button>
                      </div>
                    </div>

                  </div><!-- /.box-body -->

                </form>
              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/setting.js') }}"></script>
@stop