@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Mail Settings @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Mail Settings</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Mail Settings</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">

                <!-- form start -->
                <form action="{{ route('ajax.update.mail.settings', [1]) }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <div class="box-header with-border form-title clear">SMTP Information</div>

                    <!-- SMTP Mail Name -->
                    <div class="form-group">
                      <label for="smtp_host" class="col-sm-2 control-label">Mail Name</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" name="smtp_mail_name" placeholder="Enter the mail name..." value="{{ $settings->smtp_mail_name }}">
                      </div>
                    </div>

                    <!-- SMTP Host -->
                    <div class="form-group">
                      <label for="smtp_host" class="col-sm-2 control-label">Host</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" name="smtp_host" placeholder="Enter the SMTP Host..." value="{{ $settings->smtp_host }}">
                      </div>
                    </div>

                    <!-- SMTP Port -->
                    <div class="form-group">
                      <label for="smtp_port" class="col-sm-2 control-label">Port</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" name="smtp_port" placeholder="Enter the SMTP Port..." value="{{ $settings->smtp_port }}">
                      </div>
                    </div>

                    <!-- SMTP Username -->
                    <div class="form-group">
                      <label for="smtp_username" class="col-sm-2 control-label">Username</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" name="smtp_username" placeholder="Enter the SMTP Username..." value="{{ $settings->smtp_username }}">
                      </div>
                    </div>

                    <!-- SMTP Password -->
                    <div class="form-group">
                      <label for="smtp_password" class="col-sm-2 control-label">Password</label>
                      <div class="col-sm-10">
                        <input type="password" class="form-control" name="smtp_password" placeholder="Enter the SMTP Password..." value="{{ $settings->smtp_password }}">
                      </div>
                    </div>

                    <!-- SMTP Secure Socket -->
                    <div class="form-group">
                      <label for="smtp_secure_socket" class="col-sm-2 control-label">Secure Socket</label>
                      <div class="col-sm-10">
                        <select name="smtp_secure_socket" class="form-control">
                            <option value="ssl" @if ($settings->smtp_secure_socket == 'ssl') selected @endif>SSL</option>
                            <option value="tls" @if ($settings->smtp_secure_socket == 'tls') selected @endif>TLS</option>
                        </select>
                      </div>
                    </div>

                    <div class="box-header with-border form-title clear">General Mail Settings <em>(E-mail notification after action)</em></div>

                    <div class="col-sm-6">
                        <!-- Mail Comment Status -->
                        <div class="form-group">
                          <label for="mail_comment_status" class="col-sm-4 control-label margin-t-n-4"> Comment </label>
                          <div class="col-sm-8">
                            <input type="checkbox" name="mail_comment_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->mail_comment_status == 1) checked @endif>
                          </div>
                        </div>

                        <!-- Mail Contact Status -->
                        <div class="form-group">
                          <label for="mail_contact_status" class="col-sm-4 control-label margin-t-n-4"> Contact </label>
                          <div class="col-sm-8">
                            <input type="checkbox" name="mail_contact_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->mail_contact_status == 1) checked @endif>
                          </div>
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <!-- Mail Report Status -->
                        <div class="form-group">
                          <label for="mail_report_status" class="col-sm-4 control-label margin-t-n-4"> Report </label>
                          <div class="col-sm-8">
                            <input type="checkbox" name="mail_report_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->mail_report_status == 1) checked @endif>
                          </div>
                        </div>

                        <!-- Mail Remove Website Status -->
                        <div class="form-group">
                          <label for="mail_remove_website_status" class="col-sm-4 control-label margin-t-n-4"> Remove Website </label>
                          <div class="col-sm-8">
                            <input type="checkbox" name="mail_remove_website_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->mail_remove_website_status == 1) checked @endif>
                          </div>
                        </div>
                    </div>

                    <div class="col-sm-12">
                        <div class="form-group form-actions">
                            <button type="submit" id="mailUpdate" class="btn btn-info float-r">UPDATE</button>
                        </div>
                    </div>


                  </div><!-- /.box-body -->

                </form>
              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/setting.js') }}"></script>
@stop