@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Layout Settings @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Layout Settings</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Layout Settings</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">
                <!-- form start -->
                <form action="{{ route('ajax.update.layout.settings', [1]) }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <div class="col-sm-6">

                        <!-- Start Header Settings -->
                        <div class="box-header with-border form-title clear">Header</div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="header_bgc">Background Color :</label>
                            <div class="input-group colorpicker" id="header_bgc_bg">
                              <input type="text" name="header_bgc" id="header_bgc" class="form-control" value="{{ $layoutSetting['header_bgc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="header_link_c">Link Color :</label>
                            <div class="input-group colorpicker" id="header_link_c_bg">
                              <input type="text" name="header_link_c" id="header_link_c" class="form-control" value="{{ $layoutSetting['header_link_c'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="header_link_hc">Link Hover Color :</label>
                            <div class="input-group colorpicker" id="header_link_hc_bg">
                              <input type="text" name="header_link_hc" id="header_link_hc" class="form-control" value="{{ $layoutSetting['header_link_hc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="header_link_hbc">Link Hover Background Color :</label>
                            <div class="input-group colorpicker" id="header_link_hbc_bg">
                              <input type="text" name="header_link_hbc" id="header_link_hbc" class="form-control" value="{{ $layoutSetting['header_link_hbc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>
                        <!-- End Header Settings -->

                        <!-- Start Fixed Menu Settings -->
                        <div class="box-header with-border form-title clear">Fixed Menu (Website Detail Page)</div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="fixed_menu_bgc">Background Color :</label>
                            <div class="input-group colorpicker" id="fixed_menu_bgc_bg">
                              <input type="text" name="fixed_menu_bgc" id="fixed_menu_bgc" class="form-control" value="{{ $layoutSetting['fixed_menu_bgc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="fixed_menu_lc">Link Color :</label>
                            <div class="input-group colorpicker" id="fixed_menu_lc_bg">
                              <input type="text" name="fixed_menu_lc" id="fixed_menu_lc" class="form-control" value="{{ $layoutSetting['fixed_menu_lc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="fixed_menu_lhc">Link Hover Color :</label>
                            <div class="input-group colorpicker" id="fixed_menu_lhc_bg">
                              <input type="text" name="fixed_menu_lhc" id="fixed_menu_lhc" class="form-control" value="{{ $layoutSetting['fixed_menu_lhc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="fixed_menu_lhbc">Link Hover Background Color :</label>
                            <div class="input-group colorpicker" id="fixed_menu_lhbc_bg">
                              <input type="text" name="fixed_menu_lhbc" id="fixed_menu_lhbc" class="form-control" value="{{ $layoutSetting['fixed_menu_lhbc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="fixed_menu_bbc">Link Hover Border Bottom Color :</label>
                            <div class="input-group colorpicker" id="fixed_menu_bbc_bg">
                              <input type="text" name="fixed_menu_bbc" id="fixed_menu_bbc" class="form-control" value="{{ $layoutSetting['fixed_menu_bbc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>
                        <!-- End Fixed Menu Settings -->

                        <!-- Start Module Settings -->
                        <div class="box-header with-border form-title clear">Module</div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="module_bc">Border Color :</label>
                            <div class="input-group colorpicker" id="module_bc_bg">
                              <input type="text" name="module_bc" id="module_bc" class="form-control" value="{{ $layoutSetting['module_bc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="module_bhc">Border Hover Color :</label>
                            <div class="input-group colorpicker" id="module_bhc_bg">
                              <input type="text" name="module_bhc" id="module_bhc" class="form-control" value="{{ $layoutSetting['module_bhc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="module_shc">Shadow Hover Color :</label>
                            <div class="input-group colorpicker" id="module_shc_bg">
                              <input type="text" name="module_shc" id="module_shc" class="form-control" value="{{ $layoutSetting['module_shc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>
                        <!-- End Module Settings -->

                        <!-- Start Module Title Settings -->
                        <div class="box-header with-border form-title clear">Module Title</div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="module_title_bgc">Background Color :</label>
                            <div class="input-group colorpicker" id="module_title_bgc_bg">
                              <input type="text" name="module_title_bgc" id="module_title_bgc" class="form-control" value="{{ $layoutSetting['module_title_bgc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="module_title_fc">Font Color :</label>
                            <div class="input-group colorpicker" id="module_title_fc_bg">
                              <input type="text" name="module_title_fc" id="module_title_fc" class="form-control" value="{{ $layoutSetting['module_title_fc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>
                        <!-- End Module Title Settings -->

                        <!-- Start Module Subtitle Settings -->
                        <div class="box-header with-border form-title clear">Module Subtitle</div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="module_subtitle_bgc">Background Color :</label>
                            <div class="input-group colorpicker" id="module_subtitle_bgc_bg">
                              <input type="text" name="module_subtitle_bgc" id="module_subtitle_bgc" class="form-control" value="{{ $layoutSetting['module_subtitle_bgc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="module_subtitle_fc">Font Color :</label>
                            <div class="input-group colorpicker" id="module_subtitle_fc_bg">
                              <input type="text" name="module_subtitle_fc" id="module_subtitle_fc" class="form-control" value="{{ $layoutSetting['module_subtitle_fc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>
                        <!-- End Module Subtitle Settings -->

                        <!-- Start Footer Settings -->
                        <div class="box-header with-border form-title clear">Footer</div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="footer_bgc">Background Color :</label>
                            <div class="input-group colorpicker" id="footer_bgc_bg">
                              <input type="text" name="footer_bgc" id="footer_bgc" class="form-control" value="{{ $layoutSetting['footer_bgc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="footer_tbgc">Top Background Color :</label>
                            <div class="input-group colorpicker" id="footer_tbgc_bg">
                              <input type="text" name="footer_tbgc" id="footer_tbgc" class="form-control" value="{{ $layoutSetting['footer_tbgc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="footer_fc">Font Color :</label>
                            <div class="input-group colorpicker" id="footer_fc_bg">
                              <input type="text" name="footer_fc" id="footer_fc" class="form-control" value="{{ $layoutSetting['footer_fc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>
                        <!-- End Footer Settings -->

                    </div>

                    <div class="col-sm-6">

                        <!-- Start Button Settings -->
                        <div class="box-header with-border form-title clear">Button</div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="button_bgc">Background Color :</label>
                            <div class="input-group colorpicker" id="button_bgc_bg">
                              <input type="text" name="button_bgc" id="button_bgc" class="form-control" value="{{ $layoutSetting['button_bgc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="button_fc">Font Color :</label>
                            <div class="input-group colorpicker" id="button_fc_bg">
                              <input type="text" name="button_fc" id="button_fc" class="form-control" value="{{ $layoutSetting['button_fc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="button_bc">Border Color :</label>
                            <div class="input-group colorpicker" id="button_bc_bg">
                              <input type="text" name="button_bc" id="button_bc" class="form-control" value="{{ $layoutSetting['button_bc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="button_hbgc">Hover Background Color :</label>
                            <div class="input-group colorpicker" id="button_hbgc_bg">
                              <input type="text" name="button_hbgc" id="button_hbgc" class="form-control" value="{{ $layoutSetting['button_hbgc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="button_hfc">Hover Font Color :</label>
                            <div class="input-group colorpicker" id="button_hfc_bg">
                              <input type="text" name="button_hfc" id="button_hfc" class="form-control" value="{{ $layoutSetting['button_hfc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="button_hbc">Hover Border Color :</label>
                            <div class="input-group colorpicker" id="button_hbc_bg">
                              <input type="text" name="button_hbc" id="button_hbc" class="form-control" value="{{ $layoutSetting['button_hbc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>
                        <!-- End Button Settings -->

                        <!-- Start Search Button Settings -->
                        <div class="box-header with-border form-title clear">Search Button</div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="search_button_bgc">Background Color :</label>
                            <div class="input-group colorpicker" id="search_button_bgc_bg">
                              <input type="text" name="search_button_bgc" id="search_button_bgc" class="form-control" value="{{ $layoutSetting['search_button_bgc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="search_button_fc">Font Color :</label>
                            <div class="input-group colorpicker" id="search_button_fc_bg">
                              <input type="text" name="search_button_fc" id="search_button_fc" class="form-control" value="{{ $layoutSetting['search_button_fc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="search_button_bc">Border Color :</label>
                            <div class="input-group colorpicker" id="bsearch_button_bc_bg">
                              <input type="text" name="search_button_bc" id="search_button_bc" class="form-control" value="{{ $layoutSetting['search_button_bc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="search_button_hbgc">Hover Background Color :</label>
                            <div class="input-group colorpicker" id="search_button_hbgc_bg">
                              <input type="text" name="search_button_hbgc" id="search_button_hbgc" class="form-control" value="{{ $layoutSetting['search_button_hbgc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="search_button_hfc">Hover Font Color :</label>
                            <div class="input-group colorpicker" id="search_button_hfc_bg">
                              <input type="text" name="search_button_hfc" id="search_button_hfc" class="form-control" value="{{ $layoutSetting['search_button_hfc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>

                        <div class="form-group col-sm-11 col-sm-offset-2">
                            <label for="search_button_hbc">Hover Border Color :</label>
                            <div class="input-group colorpicker" id="search_button_hbc_bg">
                              <input type="text" name="search_button_hbc" id="search_button_hbc" class="form-control" value="{{ $layoutSetting['search_button_hbc'] }}">
                              <div class="input-group-addon">
                                <i></i>
                              </div>
                            </div>
                        </div>
                        <!-- End Search Button Settings -->

                        <!-- Start Images -->
                        <div class="box-header with-border form-title clear">Images</div>

                        <!-- Site Logo -->
                        <div class="form-group col-sm-11 upload-div">
                            <label for="module_subtitle_bgc" class="col-sm-12 margin-l-n-15">Website Logo :</label>
                            <div class="col-sm-12 margin-l-n-15">
                                <img src="{{ asset('img/' . $layoutSetting->site_logo) }}" class="img-thumbnail margin-b-10 image" style="max-width:200px; background: rgba(10, 21, 2, 0.12);">
                            </div>
                            <div class="input-group">
                                <a href="{{ route('image.upload') }}" class="image-upload" data-type="1">Upload !</a>
                            </div>
                        </div>

                        <!-- Site Favicon -->
                        <div class="form-group col-sm-11 upload-div">
                            <label for="module_subtitle_bgc" class="col-sm-12 margin-l-n-15">Website Favicon :</label>
                            <div class="col-sm-12 margin-l-n-15">
                                <img src="{{ asset('img/' . $layoutSetting->site_favicon) }}" class="img-thumbnail margin-b-10 image" style="max-width:200px;">
                            </div>
                            <div class="input-group">
                                <a href="{{ route('image.upload') }}" class="image-upload" data-type="2">Upload !</a>
                            </div>
                        </div>

                        <!-- Site Main Background -->
                        <div class="form-group col-sm-11 upload-div">
                            <label for="module_subtitle_bgc" class="col-sm-12 margin-l-n-15">Website Main Background :</label>
                            <div class="col-sm-12 margin-l-n-15">
                                <img src="{{ asset('img/' . $layoutSetting->site_main_background) }}" class="img-thumbnail margin-b-10 image" style="max-width:200px;">
                            </div>
                            <div class="input-group">
                                <a href="{{ route('image.upload') }}" class="image-upload" data-type="3">Upload !</a>
                            </div>
                        </div>

                        <!-- End Images -->


                    </div>

                    <div class="col-sm-12">
                        <div class="form-group form-actions">
                            <button type="submit" id="defaultStyleChange" class="btn btn-danger float-l">LOAD DEFAULT STYLE</button>
                            <button type="submit" id="layoutUpdate" class="btn btn-info float-r">UPDATE</button>
                        </div>
                    </div>

                  </div><!-- /.box-body -->
              </form>
            </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/setting.js') }}"></script>
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/image.js') }}"></script>
    <script>
        $(".colorpicker").colorpicker(); // Colorpicker
    </script>
@stop