@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') General Settings @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>General Settings</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">General Settings</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">
                <!-- form start -->
                <form action="{{ route('ajax.update.general.settings', [1]) }}" name="add" encty-pe="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">

                    <!-- Default Language-->
                    <div class="form-group">
                        <label for="default_lang" class="col-sm-3 control-label">Default Language</label>
                        <div class="col-sm-3">
                            <select name="default_lang" class="form-control">
                                @foreach($activeLangs as $lang)
                                    <option value="{{ $lang->id }}" @if($lang->default_lang == 1) selected @endif>{{ $lang->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- Site Name -->
                    <div class="form-group">
                      <label for="site_name" class="col-sm-3 control-label">Site Name</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="site_name" placeholder="Enter the site name..." value="{{ $settings->site_name }}">
                      </div>
                    </div>

                    <!-- Title -->
                    <div class="form-group">
                      <label for="title" class="col-sm-3 control-label">Title</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="title" placeholder="Enter the title..." value="{{ $settings->title }}">
                      </div>
                    </div>

                    <!-- Description -->
                    <div class="form-group">
                      <label for="description" class="col-sm-3 control-label">Description</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="description" placeholder="Enter the description..." value="{{ $settings->description }}">
                      </div>
                    </div>

                    <!-- Keywords -->
                    <div class="form-group">
                      <label for="keywords" class="col-sm-3 control-label">Keywords</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="keywords" placeholder="Enter the keywords..." value="{{ $settings->keywords }}">
                      </div>
                    </div>

                    <!-- Counter Code -->
                    <div class="form-group">
                      <label for="counter_code" class="col-sm-3 control-label">Counter Codes</label>
                      <div class="col-sm-9">
                         <textarea rows="9" class="form-control" name="counter_code" placeholder="Enter the counter code... (Google Analytics, Yandex Metrica etc.)">{{ $settings->counter_code }}</textarea>
                      </div>
                    </div>

                    <!-- Contact Email -->
                    <div class="form-group">
                      <label for="contact_email" class="col-sm-3 control-label">Contact Email</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="contact_email" placeholder="Enter the contact email address..." value="{{ $settings->contact_email }}">
                      </div>
                    </div>

                    <!-- After a website analysis -->
                    <div class="form-group">
                      <label for="after_a_website_analysis" class="col-sm-3 control-label">After a website analysis</label>
                      <div class="col-sm-9">
                          <div class="checkbox">
                            <label>
                              <input type="checkbox" name="after_a_website_analysis" @if ($settings->after_a_website_analysis == 1) checked @endif>
                              Website must be manually approved
                            </label>
                          </div>
                      </div>
                    </div>

                    <!-- After a website verifying -->
                    <div class="form-group">
                      <label for="after_a_website_verifying" class="col-sm-3 control-label">After a website verifying</label>
                      <div class="col-sm-9">
                          <div class="checkbox">
                            <label>
                              <input type="checkbox" name="after_a_website_verifying" @if ($settings->after_a_website_verifying == 1) checked @endif>
                              Website must be manually removed
                            </label>
                          </div>
                      </div>
                    </div>

                    <!-- Website Analysis Page (Link to analyzed website) -->
                    <div class="form-group">
                      <label for="wap_analyzed_website_link" class="col-sm-3 control-label">Website Analysis Page</label>
                      <div class="col-sm-9">
                          <div class="checkbox">
                            <label>
                              <input type="checkbox" name="wap_analyzed_website_link" @if ($settings->wap_analyzed_website_link == 1) checked @endif>
                              Link to analyzed website
                            </label>
                          </div>
                      </div>
                    </div>

                    <div class="form-group form-actions">
                      <div class="col-sm-9 col-sm-offset-3">
                        <button type="submit" id="generalUpdate" class="btn btn-info">UPDATE</button>
                      </div>
                    </div>

                  </div><!-- /.box-body -->

                </form>
              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/setting.js') }}"></script>
@stop