@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Comment Settings @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Comment Settings</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Comment Settings</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">
                <!-- form start -->
                <form action="{{ route('ajax.update.comment.settings', [1]) }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <div class="box-header with-border form-title">
                      Comment System Options
                    </div>

                    <!-- Comment Default -->
                    <div class="form-group">
                      <label for="comment_default" class="col-sm-2 control-label">Default</label>
                      <div class="col-sm-10">
                        <input type="checkbox" name="comment_default" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->comment_default == 1) checked @endif>
                        <span class="margin-l-10">Default comment system</span>
                      </div>
                    </div>

                    <!-- Comment Disqus -->
                    <div class="form-group">
                      <label for="comment_disqus" class="col-sm-2 control-label">Disqus </label>
                      <div class="col-sm-10">
                        <input type="checkbox" name="comment_disqus" id="comment_disqus" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->comment_disqus == 1) checked @endif>

                      </div>
                    </div>

                    <div id="comment_disqus_username" @if ($settings->comment_disqus == 0) style="display: none" @endif>
                        <!-- Disqus Username -->
                        <div class="form-group sea-blue-bg">
                          <label for="comment_disqus_username" class="col-sm-2 control-label">Disqus Username</label>
                          <div class="col-sm-10">
                            <input type="text" class="form-control" name="comment_disqus_username" placeholder="Enter the Disqus username..." value="{{ $settings->comment_disqus_username }}">
                            <span class="help-block margin-b-5">Get your Disqus Username from here <a href="https://disqus.com/admin/signup/?utm_source=New-Site" target="_blank"><strong>add Disqus to your site.</strong></a></span>
                          </div>
                        </div>
                    </div>

                    <!-- Comment Facebook -->
                    <div class="form-group">
                      <label for="comment_facebook" class="col-sm-2 control-label">Facebook</label>
                      <div class="col-sm-10">
                        <input type="checkbox" name="comment_facebook" id="comment_facebook" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->comment_facebook == 1) checked @endif>
                      </div>
                    </div>

                    <div id="comment_facebook_key" @if ($settings->comment_facebook == 0) style="display: none" @endif>
                        <!-- Facebook App ID -->
                        <div class="form-group sea-blue-bg">
                          <label for="comment_facebook_app_id" class="col-sm-2 control-label">Facebook App ID</label>
                          <div class="col-sm-10">
                            <input type="text" class="form-control" name="comment_facebook_app_id" placeholder="Enter the Facebook App ID..." value="{{ $settings->api_facebook_app_id }}">
                          </div>
                        </div>

                        <!-- Facebook Comment Limit -->
                        <div class="form-group sea-blue-bg">
                          <label for="comment_facebook_limit" class="col-sm-2 control-label">Facebook Comment Limit</label>
                          <div class="col-sm-10">
                            <input type="text" class="form-control" name="comment_facebook_limit" placeholder="Enter the Facebook comment limit..." value="{{ $settings->comment_facebook_limit }}">
                          </div>
                        </div>
                    </div>

                    <div class="form-group form-actions">
                      <div class="col-sm-10 col-sm-offset-2">
                        <button type="submit" id="commentUpdate" class="btn btn-info">UPDATE</button>
                      </div>
                    </div>

                  </div><!-- /.box-body -->

                </form>
              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/setting.js') }}"></script>
@stop