@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Cache Settings @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Cache Settings</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Cache Settings</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">
                <!-- form start -->
                <form action="{{ route('ajax.update.cache.settings', [1]) }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <table class="table table-bordered table-striped table-responsive">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Cache Expire Time</th>
                                <th class="text-center">Cache Status</th>
                            </tr>
                        </thead>

                        <tbody>
                            <tr>
                                <td class="vcenter">Home Page</td>
                                <td><input type="text" class="form-control" name="cache_hp_et" placeholder="Enter the cache time... (Second)" value="{{ $settings->cache_hp_et }}"></td>
                                <td class="text-center"><input type="checkbox" name="cache_hp_s" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->cache_hp_s == 1) checked @endif></td>
                            </tr>

                            <tr>
                                <td class="vcenter">Website Analysis Page</td>
                                <td><input type="text" class="form-control" name="cache_wap_et" placeholder="Enter the cache time... (Second)" value="{{ $settings->cache_wap_et }}"></td>
                                <td class="text-center"><input type="checkbox" name="cache_wap_s" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->cache_wap_s == 1) checked @endif></td>
                            </tr>

                            <tr>
                                <td class="vcenter">Country Detail Page</td>
                                <td><input type="text" class="form-control" name="cache_ctp_et" placeholder="Enter the cache time... (Second)" value="{{ $settings->cache_ctp_et }}"></td>
                                <td class="text-center"><input type="checkbox" name="cache_ctp_s" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->cache_ctp_s == 1) checked @endif></td>
                            </tr>

                            <tr>
                                <td class="vcenter">Pages</td>
                                <td><input type="text" class="form-control" name="cache_p_et" placeholder="Enter the cache time... (Second)" value="{{ $settings->cache_p_et }}"></td>
                                <td class="text-center"><input type="checkbox" name="cache_p_s" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->cache_p_s == 1) checked @endif></td>
                            </tr>

                            <tr>
                                <td class="vcenter">Sidebar</td>
                                <td><input type="text" class="form-control" name="cache_s_et" placeholder="Enter the cache time... (Second)" value="{{ $settings->cache_s_et }}"></td>
                                <td class="text-center"><input type="checkbox" name="cache_s_s" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->cache_s_s == 1) checked @endif></td>
                            </tr>
                        </tbody>
                    </table>


                    <div class="form-group form-actions">
                      <div>
                        <a href="{{ route('ajax.clear.all.cache') }}" class="btn btn-danger" id="clearAllCache">CLEAR ALL CACHE</a>
                        <button type="submit" id="cacheUpdate" class="btn btn-info float-r">UPDATE</button>
                      </div>
                    </div>

                  </div>

                </form>
              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/setting.js') }}"></script>
@stop