@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Api Key Settings @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Api Key Settings</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Api Key Settings</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">
                <!-- form start -->
                <form action="{{ route('ajax.update.api.key.settings', [1]) }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <!-- Google Api Key -->
                    <div class="form-group">
                      <label for="google_api" class="col-sm-3 control-label">Google Api Key</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="google_api" placeholder="Enter the Google Api key..." value="{{ $settings->api_google_key }}">
                      </div>
                    </div>

                    <!-- Bing Account Key -->
                    <div class="form-group">
                      <label for="bing_account" class="col-sm-3 control-label">Bing Account Key</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="bing_account" placeholder="Enter the Bing account key..." value="{{ $settings->api_bing_account }}">
                      </div>
                    </div>

                    <!-- Google Recaptcha Site Key -->
                    <div class="form-group">
                      <label for="google_recaptcha_site" class="col-sm-3 control-label">Google Recaptcha Site Key</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="google_recaptcha_site" placeholder="Enter the Google recaptcha site key..." value="{{ $settings->api_google_recaptcha_site_key }}">
                      </div>
                    </div>

                    <!-- Google Recaptcha Secret Key -->
                    <div class="form-group">
                      <label for="google_recaptcha_secret" class="col-sm-3 control-label">Google Recaptcha Secret Key</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="google_recaptcha_secret" placeholder="Enter the Google recaptcha secret key..." value="{{ $settings->api_google_recaptcha_secret_key }}">
                      </div>
                    </div>

                    <!-- Google Analytics Client ID -->
                    <div class="form-group">
                      <label for="google_analytics_client_id" class="col-sm-3 control-label">Google Analytics Client ID</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="google_analytics_client_id" placeholder="Enter the Google Analytics Client ID..." value="{{ $settings->api_google_analytics_client_id }}">
                      </div>
                    </div>

                    <!-- Google Analytics Service E-Mail -->
                    <div class="form-group">
                      <label for="google_analytics_service_email" class="col-sm-3 control-label">Google Analytics Service E-Mail</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="google_analytics_service_email" placeholder="Enter the Google Analytics Service E-Mail..." value="{{ $settings->api_google_analytics_service_email }}">
                      </div>
                    </div>

                    <!-- Google Analytics File -->
                    <div class="form-group upload-div">
                      <label for="google_analytics_file" class="col-sm-3 control-label">Google Analytics Certificate File</label>
                      <div class="col-sm-9">
                           <div class="input-group">
                               <a href="{{ route('file.upload') }}" class="file-upload" data-type="1">Upload !</a>
                           </div>
                      </div>
                    </div>

                    <!-- Whois Api Key-->
                    <div class="form-group">
                      <label for="api_whois_key" class="col-sm-3 control-label">Whois Api Key</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="api_whois_key" placeholder="Enter the Whois api key..." value="{{ $settings->api_whois_key }}">
                        <span class="help-block">Enter the <a href="https://jsonwhois.com/signup">Jsonwhois.com</a> whois api website and take an api key.</span>
                      </div>
                    </div>

                    <!-- Pagepeeker (Website Screenshot) -->
                    <div class="form-group">
                      <label for="pagepeeker_api_status" class="col-sm-3 control-label margin-t-n-4"> Pagepeeker (Website Screenshot)</label>
                      <div class="col-sm-9">
                        <div class="radio">
                          <label>
                            <input type="radio" name="pagepeeker_api_status" class="pagepeeker_api_status" value="0" @if ($settings->api_pagepeeker_status == 0) checked @endif>
                            Free
                          </label>
                        </div>
                        <div class="radio">
                          <label>
                            <input type="radio" name="pagepeeker_api_status" class="pagepeeker_api_status" value="1" @if ($settings->api_pagepeeker_status == 1) checked @endif>
                            Paid (<a href="http://pagepeeker.com/site-thumbs-pricing/" target="_blank">Website Screenshot Pricing</a>)
                          </label>
                        </div>

                        <div id="pagepeeker_api" @if ($settings->api_pagepeeker_status == 0) style="display:none" @endif>
                            <label for="pagepeeker_api_status" class="col-sm-9 margin-t-10 margin-b-0 margin-l-n-15"> Pagepeeker Api Key</label>
                            <input type="text" class="col-sm-9 form-control margin-t-10" name="pagepeeker_api" placeholder="Enter the Pagepeeker api key..." value="{{ $settings->api_pagepeeker_key }}">
                        </div>

                      </div>
                    </div>

                    <div class="form-group form-actions">
                      <div class="col-sm-9 col-sm-offset-3">
                        <button type="submit" id="apiKeyUpdate" class="btn btn-info">UPDATE</button>
                      </div>
                    </div>

                  </div><!-- /.box-body -->
                </form>

              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/setting.js') }}"></script>
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/image.js') }}"></script>
@stop