@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Ads Management @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Ads Management</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Ads Management</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">
                <!-- form start -->
                <form action="{{ route('ajax.update.ads.settings', [1]) }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <table class="table table-bordered table-striped table-responsive">
                        <thead>
                            <tr>
                                <th width="30%">#</th>
                                <th>Ad space</th>
                                <th class="text-center">Status</th>
                            </tr>
                        </thead>

                        <tbody>
                            <tr>
                                <td class="vcenter">Sidebar - 336 x 280 or Responsive <strong>(Top)</strong></td>
                                <td><textarea rows="8" name="ads_sidebar_top_code" class="form-control">{{ $settings->ads_sidebar_top_code }}</textarea></td>
                                <td class="vcenter text-center"><input type="checkbox" name="ads_sidebar_top_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->ads_sidebar_top_status == 1) checked @endif></td>
                            </tr>

                            <tr>
                                <td class="vcenter">Sidebar - 336 x 280 or Responsive <strong>(Bottom)</strong></td>
                                <td><textarea rows="8" name="ads_sidebar_bottom_code" class="form-control">{{ $settings->ads_sidebar_bottom_code }}</textarea></td>
                                <td class="vcenter text-center"><input type="checkbox" name="ads_sidebar_bottom_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->ads_sidebar_bottom_status == 1) checked @endif></td>
                            </tr>

                            <tr>
                                <td class="vcenter">Website Detail Page - 728 x 90 or Responsive <strong>(Header)</strong></td>
                                <td><textarea rows="8" name="ads_wtp_header_code" class="form-control">{{ $settings->ads_wtp_header_code }}</textarea></td>
                                <td class="vcenter text-center"><input type="checkbox" name="ads_wtp_header_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->ads_wtp_header_status == 1) checked @endif></td>
                            </tr>

                            <tr>
                                <td class="vcenter">Website Detail Page - 336 x 280 or Responsive <strong>(Comments)</strong></td>
                                <td><textarea rows="8" name="ads_wtp_comments_code" class="form-control">{{ $settings->ads_wtp_comments_code }}</textarea></td>
                                <td class="vcenter text-center"><input type="checkbox" name="ads_wtp_comments_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->ads_wtp_comments_status == 1) checked @endif></td>
                            </tr>

                            <tr>
                                <td class="vcenter">Website Detail Page - 336 x 280 or Responsive <strong>(Facebook Comments)</strong></td>
                                <td><textarea rows="8" name="ads_wtp_fb_comments_code" class="form-control">{{ $settings->ads_wtp_fb_comments_code }}</textarea></td>
                                <td class="vcenter text-center"><input type="checkbox" name="ads_wtp_fb_comments_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->ads_wtp_fb_comments_status == 1) checked @endif></td>
                            </tr>

                            <tr>
                                <td class="vcenter">All Pages - 728 x 90 or Responsive <strong>(Header)</strong></td>
                                <td><textarea rows="8" name="ads_ap_header_code" class="form-control">{{ $settings->ads_ap_header_code }}</textarea></td>
                                <td class="vcenter text-center"><input type="checkbox" name="ads_ap_header_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->ads_ap_header_status == 1) checked @endif></td>
                            </tr>

                            <tr>
                                <td class="vcenter">Countries Page - 336 x 280 or Responsive</td>
                                <td><textarea rows="8" name="ads_cp_code" class="form-control">{{ $settings->ads_cp_code }}</textarea></td>
                                <td class="vcenter text-center"><input type="checkbox" name="ads_cp_status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($settings->ads_cp_status == 1) checked @endif></td>
                            </tr>
                        </tbody>
                    </table>

                    <div class="form-group form-actions">
                      <div>
                        <button type="submit" id="adsUpdate" class="btn btn-info float-r">UPDATE</button>
                      </div>
                    </div>

                  </div>

                </form>
              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/setting.js') }}"></script>
@stop