@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Show Report @stop

@section('metas')
@stop

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>Show Report</h1>
        <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ route('reports') }}">Reports</a></li>
            <li class="active">Show</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">

            <!-- /.col -->
            <div class="col-md-12">
                <div class="box box-primary">

                    <div class="box-body no-padding">
                        <div class="mailbox-read-info">
                            <h3>Website : <a href="{{ route('site.name', [$report->site_name]) }}" target="_blank">{{ $report->site_name }}</a></h3>
                            <h5>From: {{ $report->email }}
                                <span class="mailbox-read-time pull-right">{{ $report->created_at }}</span></h5>
                        </div>
                        <!-- /.mailbox-read-info -->

                        <div class="mailbox-read-message">
                            <h4>{{ $report->subject }}</h4>
                            {{ $report->message }}
                        </div>
                        <!-- /.mailbox-read-message -->
                    </div>
                    <!-- /.box-body -->

                </div>
                <!-- /. box -->
            </div>
            <!-- /.col -->
        </div>
    </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/j/report.js') }}"></script>
@stop