@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Add Page @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Add Page</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ route('pages') }}">Pages</a></li>
            <li class="active">Add Page</li>
          </ol>
        </section>

        <section class="content">
            <form action="{{ route('ajax.create.page') }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">

              <div class="box-group" id="accordion">
              <!-- we are adding the .panel class so bootstrap.js collapse plugin detects it -->
                @foreach ($activeLangs as $i => $lang)
                    <div class="panel box">
                      <div class="box-header with-border">
                        <h4 class="box-title">
                          <a data-toggle="collapse" data-parent="#accordion" href="#{{ $lang->short }}" aria-expanded="false" class="collapsed">
                            <img src="{{ asset('img/languages/' . $lang['short'] . '.png') }}"> {{ $lang->name }}
                          </a>
                        </h4>
                      </div>
                      <div id="{{ $lang->short }}" class="panel-collapse collapse @if ($i == 0) in @endif" aria-expanded="@if ($i == 0) true @else false @endif">

                          <div class="box-body">
                            <!-- Page Title -->
                            <div class="form-group">
                              <label for="page_title[{{ $lang->short }}]" class="col-sm-2 control-label">Page Title</label>
                              <div class="col-sm-10">
                                <input type="text" class="form-control" name="page_title[{{ $lang->short }}]" placeholder="Enter the page title...">
                              </div>
                            </div>

                            <!-- Title-->
                            <div class="form-group">
                              <label for="title[{{ $lang->short }}]" class="col-sm-2 control-label">Title</label>
                              <div class="col-sm-10">
                                <input type="text" class="form-control" name="title[{{ $lang->short }}]" placeholder="Enter the title...">
                                <span class="help-block">Sayfanın <strong><em>&lt;title&gt; &lt;/title&gt;</em></strong> etiketleri arasında gözükecek olan başlıktır. Boş bırakırsanız <strong>otomatik</strong> olarak hazırlanır.</span>
                              </div>
                            </div>

                            <!-- Description -->
                            <div class="form-group">
                              <label for="description[{{ $lang->short }}]" class="col-sm-2 control-label">Description</label>
                              <div class="col-sm-10">
                                <input type="text" class="form-control" name="description[{{ $lang->short }}]" placeholder="Enter the page description...">
                              </div>
                            </div>

                            <!-- Keywords -->
                            <div class="form-group">
                              <label for="keywords[{{ $lang->short }}]" class="col-sm-2 control-label">Keywords</label>
                              <div class="col-sm-10">
                                <input type="text" class="form-control" name="keywords[{{ $lang->short }}]" placeholder="Enter the page keywords...">
                              </div>
                            </div>

                            <!-- Content -->
                            <div class="form-group">
                              <label for="content[{{ $lang->short }}]" class="col-sm-2 control-label">Content</label>
                              <div class="col-sm-10">
                                  <textarea class="ckeditor" name="content[{{ $lang->short }}]" rows="10" cols="80"></textarea>
                              </div>
                            </div>

                          </div><!-- /.box-body -->

                      </div>
                    </div>
                @endforeach

              </div>

              <div class="row">
                <!-- right column -->
                <div class="col-md-12">
                  <!-- Horizontal Form -->
                  <div class="box">
                    <!-- form start -->
                    <div class="form-horizontal form-bordered">
                      <div class="box-body">

                        <!-- Slug-->
                        <div class="form-group">
                          <label for="slug" class="col-sm-2 control-label">Slug</label>
                          <div class="col-sm-10">
                            <input type="text" class="form-control" name="slug" placeholder="Enter the slug you want...">
                          </div>
                        </div>

                        <!-- Status -->
                        <div class="form-group">
                          <label for="status" class="col-sm-2 control-label">Publication Status</label>
                          <div class="col-sm-10">
                            <input type="checkbox" name="status" class="switch" checked data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small">
                          </div>
                        </div>

                        <input type="hidden" name="default_lang_short_code" value="{{ $defaultLang->short }}">

                        <div class="form-group form-actions">
                          <div class="col-sm-10 col-sm-offset-2">
                            <button type="submit" id="add" class="btn btn-info">ADD</button>
                          </div>
                        </div>

                      </div><!-- /.box-body -->

                    </div>
                  </div><!-- /.box -->

                </div><!--/.col (right) -->
              </div>   <!-- /.row -->

            </form>
        </section>
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/page.js') }}"></script>
@stop