@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Edit Language @stop

@section('metas')
@stop

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>Edit Language</h1>
        <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ route('languages') }}">Languages</a></li>
            <li class="active">
                @foreach($languages as $language)
                    @if($language->id == $currentLanguage) {{ $language->name }} @endif
                @endforeach
            </li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- right column -->
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box">
                    <!-- form start -->
                    <form action="{{ route('ajax.update.language', [$currentLanguage]) }}" name="update" enctype="multipart/form-data" class="form-horizontal form-bordered">
                        <div class="box-body">


                            <!-- Language-->
                            <div class="form-group">
                                <label for="title" class="col-sm-3 control-label">Language</label>
                                <div class="col-sm-3">
                                    <select name="language" class="form-control" disabled>
                                        @foreach($languages as $language)
                                            <option value="{{ $language->id }}" @if($language->id == $currentLanguage) selected @endif>{{ $language->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            @foreach($translations as $key => $translation)
                                <div class="form-group">
                                    <label for="slug" class="col-sm-3 control-label">{{ $key }}</label>
                                    <div class="col-sm-9">
                                        @if($translation['editor'] == 0)
                                            <input type="text" class="form-control" name="lang[{{ $key }}][text]" placeholder="Enter the translation text..." value="{{ $translation['text'] }}">
                                        @else
                                            <textarea class="ckeditor" name="lang[{{ $key }}][text]" rows="10" cols="80">{{ $translation['text'] }}</textarea>
                                        @endif
                                            <input type="hidden" name="lang[{{ $key }}][editor]" value="{{ $translation['editor'] }}"/>
                                    </div>
                                </div>
                            @endforeach

                            <div class="form-group form-actions">
                                <div class="col-sm-9 col-sm-offset-3">
                                    <button type="submit" id="update" class="btn btn-info">UPDATE</button>
                                </div>
                            </div>

                        </div><!-- /.box-body -->

                    </form>
                </div><!-- /.box -->

            </div><!--/.col (right) -->
        </div>   <!-- /.row -->
    </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/language.js') }}"></script>
@stop