@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Add Language @stop

@section('metas')
@stop

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>Add Language</h1>
        <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ route('languages') }}">Languages</a></li>
            <li class="active">Add Language</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- right column -->
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box">
                    <!-- form start -->
                    <form action="{{ route('ajax.create.language') }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                        <div class="box-body">


                            <!-- Language-->
                            <div class="form-group">
                                <label for="title" class="col-sm-2 control-label">Language</label>
                                <div class="col-sm-3">
                                    <select name="language" class="form-control">
                                        @foreach($languages as $language)
                                            <option value="{{ $language->id }}">{{ $language->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            @foreach($languageKeys as $key)
                            <div class="form-group">
                                <label for="slug" class="col-sm-2 control-label">{{ $key->lang_key }}</label>
                                <div class="col-sm-10">
                                    @if($key->editor == 0)
                                        <input type="text" class="form-control" name="lang[{{ $key->lang_key }}][text]" placeholder="Enter the translation text...">
                                    @else
                                        <textarea class="ckeditor" name="lang[{{ $key->lang_key }}][text]" rows="10" cols="80"></textarea>
                                    @endif
                                    <input type="hidden" name="lang[{{ $key->lang_key }}][editor]" value="{{ $key->editor }}"/>
                                </div>
                            </div>
                            @endforeach

                            <div class="form-group form-actions">
                                <div class="col-sm-10 col-sm-offset-2">
                                    <button type="submit" id="add" class="btn btn-info">ADD</button>
                                </div>
                            </div>

                        </div><!-- /.box-body -->

                    </form>
                </div><!-- /.box -->

            </div><!--/.col (right) -->
        </div>   <!-- /.row -->
    </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/language.js') }}"></script>
@stop