@extends('admin.layouts.master')

@section('title') Dashboard @stop

@section('content')

    <section class="content-header">
        <h1>
            Dashboard
        </h1>
        <ol class="breadcrumb">
            <li><i class="fa fa-dashboard margin-r-5"></i> Dashboard</li>
        </ol>
    </section>
    <section class="content">

        @if (!$settings->api_google_key || !$settings->api_bing_account || !$settings->api_google_recaptcha_site_key || !$settings->api_google_recaptcha_secret_key || ($settings->api_pagepeeker_status == 1 && !$settings->api_pagepeeker_key))
            <div class="callout callout-info lead">
                <h4>Warning !</h4>
                <p>There are missing API keys that you DID NOT entered. If you want all the details to be listed in web analysis, please enter the missing API keys from the <a href="{{ route('api.key.settings') }}">'Api Key Settings'</a> page.</p>
            </div>
        @endif

        <!-- Info boxes -->
        <div class="row">
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-aqua"><i class="fa fa-globe"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">Total Websites</span>
                        <span class="info-box-number">{{ $totalWebsites }}</span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-red"><i class="fa fa-line-chart"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">Today Analyzed Website</span>
                        <span class="info-box-number">{{ $todayAnalyzedWebsite }}</span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->

            <!-- fix for small devices only -->
            <div class="clearfix visible-sm-block"></div>

            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-green"><i class="fa fa-user"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">Today Unique Visitors</span>
                        <span class="info-box-number">{{ $todayUniqueVisitors }}</span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-users"></i></span>

                    <div class="info-box-content">
                        <span class="info-box-text">Today Pageviews</span>
                        <span class="info-box-number">{{ $todayPageviews }}</span>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

        <div class="row">
            <div class="col-md-12">
                <!-- AREA CHART -->
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Pageviews & Visits</h3>

                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="chart">
                            <canvas id="areaChart" style="height:250px"></canvas>
                        </div>
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!-- /.row -->


        <!-- Main row -->
        <div class="row">
            <!-- Left col -->
            <div class="col-md-8">

            <div class="row">
                <div class="col-md-6">
                    <div class="small-box bg-red">
                        <div class="inner">
                            <h3>{{ $totalVisitors }}</h3>
                            <p>Total Unique Visitors</p>
                        </div>
                        <div class="icon">
                            <i class="fa fa fa-user"></i>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="small-box bg-green">
                        <div class="inner">
                            <h3>{{ $totalPageviews }}</h3>
                            <p>Total Pageviews</p>
                        </div>
                        <div class="icon">
                            <i class="fa fa-chain"></i>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <!-- TABLE: LATEST ORDERS -->
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Popular Keywords</h3>

                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                </button>
                                <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="table-responsive">
                                <table class="table no-margin">
                                    <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Keyword</th>
                                        <th class="text-center">Visitors</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @if($keywords)
                                        @foreach ($keywords as $i => $keyword)
                                            <tr @if ($i >= 5) class="hidden" @endif>
                                                <th>{{ $i+1 }}</th>
                                                <td>{{ $keyword[0] }}</td>
                                                <td class="text-center"><span class="label label-success">{{ $keyword[1] }}</span></td>
                                            </tr>
                                        @endforeach
                                    @endif
                                    </tbody>
                                </table>

                                @if($keywords)
                                    @if ($i >= 5)
                                        <div class="box-footer padding-10 clearfix">
                                            <a href="#" class="btn btn-sm btn-info btn-flat pull-right see-more-table">More</a>
                                        </div>
                                    @endif
                                @endif

                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.box-body -->

                    </div>
                    <!-- /.box -->

                    <!-- TABLE: LATEST ORDERS -->
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Referral Traffic</h3>

                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                </button>
                                <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="table-responsive">
                                <table class="table no-margin">
                                    <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Referer</th>
                                        <th class="text-center">Visitors</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @if($referers)
                                        @foreach ($referers as $i => $referer)
                                            <tr @if ($i >= 5) class="hidden" @endif>
                                                <th>{{ $i+1 }}</th>
                                                <td>{{ $referer[0] }}</td>
                                                <td class="text-center"><span class="label label-success">{{ $referer[1] }}</span></td>
                                            </tr>
                                        @endforeach
                                    @endif
                                    </tbody>
                                </table>
                                @if($referers)
                                    @if ($i >= 5)
                                        <div class="box-footer padding-10 clearfix">
                                            <a href="#" class="btn btn-sm btn-info btn-flat pull-right see-more-table">More</a>
                                        </div>
                                    @endif
                                @endif
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.box-body -->

                    </div>
                    <!-- /.box -->

                </div>

                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Browser Usage</h3>

                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                </button>
                                <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="chart-responsive">
                                        <canvas id="pieChart" height="150"></canvas>
                                    </div>
                                    <!-- ./chart-responsive -->
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer no-padding">
                            <ul class="nav nav-pills nav-stacked">
                                <li class="title">Browser <span class="pull-right">Visitors</span></li>
                                @if($browsers)
                                    @foreach($browsers as $browser)
                                    <li class="content-item">
                                        {{ $browser[0] }}
                                        <span class="pull-right text-green">{{ $browser[1] }}</span>
                                    </li>
                                    @endforeach
                                @endif
                            </ul>
                        </div>
                        <!-- /.footer -->
                    </div>
                    <!-- /.box -->
                </div>

                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Operating System Usage</h3>

                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                </button>
                                <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="chart-responsive">
                                        <canvas id="osPieChart" height="150"></canvas>
                                    </div>
                                    <!-- ./chart-responsive -->
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer no-padding">
                            <ul class="nav nav-pills nav-stacked">
                                <li class="title">OS <span class="pull-right">Visitors</span></li>
                                @if($os)
                                    @foreach($os as $osItem)
                                    <li class="content-item">
                                        {{ $osItem[0] }}
                                        <span class="pull-right text-green">{{ $osItem[1] }}</span>
                                    </li>
                                    @endforeach
                                @endif
                            </ul>
                        </div>
                        <!-- /.footer -->
                    </div>
                    <!-- /.box -->
                </div>

            </div>



            </div>
            <!-- /.col -->

            <div class="col-md-4">

                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Screen Usage</h3>

                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="chart-responsive">
                                    <canvas id="screensPieChart" height="150"></canvas>
                                </div>
                                <!-- ./chart-responsive -->
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer no-padding">
                        <ul class="nav nav-pills nav-stacked">
                            <li class="title">Screen <span class="pull-right">Visitors</span></li>
                            @if($screens)
                                @foreach($screens as $screen)
                                <li class="content-item">
                                    {{ $screen[0] }}
                                    <span class="pull-right text-green">{{ $screen[1] }}</span>
                                </li>
                                @endforeach
                            @endif
                        </ul>
                    </div>
                    <!-- /.footer -->
                </div>
                <!-- /.box -->

                <!-- TABLE: LATEST ORDERS -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">Popular Cities</h3>

                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table no-margin">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>City</th>
                                    <th class="text-center">Visitors</th>
                                </tr>
                                </thead>
                                <tbody>

                                @if($cities)
                                    @foreach ($cities as $i => $city)
                                        <tr @if ($i >= 10) class="hidden" @endif>
                                            <th>{{ $i+1 }}</th>
                                            <td>{{ $city[0] }}</td>
                                            <td class="text-center"><span class="label label-success">{{ $city[1] }}</span></td>
                                        </tr>
                                    @endforeach
                                @endif

                                </tbody>
                            </table>
                            @if($cities)
                                @if ($i >= 5)
                                    <div class="box-footer padding-10 clearfix">
                                        <a href="#" class="btn btn-sm btn-info btn-flat pull-right see-more-table">More</a>
                                    </div>
                                @endif
                            @endif

                        </div>
                        <!-- /.table-responsive -->
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->

            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

    </section>

@stop
@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/plugins/chartjs/Chart.min.js') }}"></script>
    <!-- Sparkline -->
    <script src="{{ asset('admin-assets/plugins/sparkline/jquery.sparkline.min.js') }}"></script>
    <!-- jvectormap -->
    <script src="{{ asset('admin-assets/plugins/jvectormap/jquery-jvectormap-1.2.2.min.js') }}"></script>
    <script src="{{ asset('admin-assets/plugins/jvectormap/jquery-jvectormap-world-mill-en.js') }}"></script>

    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/dashboard.js') }}"></script>

    <script>
        var areaChartDatas = {
            days : {{ json_encode($days) }},
            visits : {{ json_encode($visits) }},
            pageviews : {{ json_encode($pageviews) }}
        };

        var colors = [
            '#f56954',
            '#00a65a',
            '#3c8dbc',
            '#d2d6de',
            '#00c0ef',
            '#e95321',
            '#5b90bf',
            '#cc9900',
            '#993399',
            '#339933',
            '#9999CC',
            '#8fa1b3',
            '#b48ead',
            '#ab7967',
            '#eeaf7c',
            '#2ca9af',
            '#c47938',
            '#9f1c32',
            '#58a56a',
            '#a7bcfd',
            '#f178a7',
            '#4d3a27',
            '#2f4247',
            '#565600',
            '#82c66d',
            '#de7a8a',
            '#d1ab3e',
            '#2559a1',
            '#5bc254',
            '#e07856',
            '#ffb900',
            '#ff8850',
            '#fdc800',
            '#f8c492',
            '#f8823c',
            '#f1a744',
            '#b0d9f5',
            '#abd6ba',
            '#d81e28',
            '#88b922',
            '#84267e',
            '#0014a8',

            '#0014a8',
            '#0014a8',

        ];

        // BROWSER PIE
        var pieDatas = [];

        @if($browsers)
            @foreach($browsers as $browser)
                var randomColor = colors[Math.floor(Math.random() * colors.length)];
                var removeColor = randomColor;

                pieDatas.push({
                    value: "{{ $browser[1] }}",
                    color: randomColor,
                    highlight: randomColor,
                    label: "{{ $browser[0] }}"
                });

                // Array - Remove Color
                colors = $.grep(colors, function(value) {
                    return value != removeColor;
                });
                console.log(colors);
            @endforeach
        @endif

        // SCREEN PIE
        var screenPieDatas = [];

        @if($screens)
            @foreach($screens as $screen)
                var randomColor = colors[Math.floor(Math.random() * colors.length)];
                var removeColor = randomColor;

                screenPieDatas.push({
                    value: "{{ $screen[1] }}",
                    color: randomColor,
                    highlight: randomColor,
                    label: "{{ $screen[0] }}"
                });

                // Array - Remove Color
                colors = $.grep(colors, function(value) {
                    return value != removeColor;
                });
                console.log(colors);
            @endforeach
        @endif

        // OS PIE
        var osPieDatas = [];

        @if($os)
            @foreach($os as $osItem)
                var randomColor = colors[Math.floor(Math.random() * colors.length)];
                var removeColor = randomColor;

                osPieDatas.push({
                    value: "{{ $osItem[1] }}",
                    color: randomColor,
                    highlight: randomColor,
                    label: "{{ $osItem[0] }}"
                });

                // Array - Remove Color
                colors = $.grep(colors, function(value) {
                    return value != removeColor;
                });
                console.log(colors);
            @endforeach
        @endif

    </script>
@stop