@extends('admin.layouts.master')

@section('title') Edit Comment @stop


@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>Edit Comment </h1>
        <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ route('comments') }}">Comments</a></li>
            <li class="active">Edit Comment</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- right column -->
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box">
                    <!-- form start -->
                    <form action="{{ route('ajax.update.comment', [$comment->id]) }}" name="edit" class="form-horizontal form-bordered">
                        <div class="box-body">

                            <!-- Slug-->
                            <div class="form-group">
                                <label for="slug" class="col-sm-2 control-label">Website</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" value="{{ $comment->site_name }}" disabled>
                                </div>
                            </div>
                            <!-- Name -->
                            <div class="form-group">
                                <label for="name" class="col-sm-2 control-label">Name</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="name" placeholder="Enter the name..." value="{{ $comment->name }}">
                                </div>
                            </div>

                            <!-- E-Mail -->
                            <div class="form-group">
                                <label for="email" class="col-sm-2 control-label">E-Mail</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="email" placeholder="Enter the e-mail..." value="{{ $comment->email }}">
                                </div>
                            </div>

                            <!-- Comment -->
                            <div class="form-group">
                                <label for="comment" class="col-sm-2 control-label">Comment</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" name="comment" placeholder="Enter the comment...">{{ $comment->comment }}</textarea>
                                </div>
                            </div>

                            <!-- IP Address -->
                            <div class="form-group">
                                <label for="ip-address" class="col-sm-2 control-label">IP Address</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" name="ip" value="{{ $comment->ip_address }}">
                                </div>
                            </div>

                            <!-- Created Time -->
                            <div class="form-group">
                                <label for="created_at" class="col-sm-2 control-label">Created Time</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" value="{{ $comment->created_at }}" disabled>
                                </div>
                            </div>

                            <!-- Updated Time -->
                            <div class="form-group">
                                <label for="ip-address" class="col-sm-2 control-label">Updated Time</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" value="{{ $comment->updated_at }}" disabled>
                                </div>
                            </div>

                            <!-- Comment Status -->
                            <div class="form-group">
                                <label for="status" class="col-sm-2 control-label">Comment Status</label>
                                <div class="col-sm-10">
                                    <input type="checkbox" name="status" class="switch" @if($comment->status == 1) checked @endif value="1" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small">
                                </div>
                            </div>

                            <div class="form-group form-actions">
                                <div class="col-sm-10 col-sm-offset-2">
                                    <button type="button" id="update" class="btn btn-info">UPDATE</button>
                                </div>
                            </div>

                        </div><!-- /.box-body -->

                    </form>
                </div><!-- /.box -->

            </div><!--/.col (right) -->
        </div>   <!-- /.row -->
    </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/comment.js') }}"></script>
@stop