@extends('admin.auth.layouts.master')

@section('content')

    @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Warning !</strong> Messages : <br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (Session::has('status'))
        <div class="alert alert-success">
            <p>{{{ Session::get('status') }}}</p>
        </div>
    @endif

    <form action="{{ route('account.password.reset.form') }}" method="post">
        <input type="hidden" name="token" value="{{ $token }}">
        <div class="form-group has-feedback">
            <input type="text" name="email" class="form-control" placeholder="Email">
            <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
        </div>
        <div class="form-group has-feedback">
            <input type="password" name="password" class="form-control" placeholder="New Password">
            <span class="glyphicon glyphicon-lock form-control-feedback"></span>
        </div>
        <div class="form-group has-feedback">
            <input type="password" name="password_confirmation" class="form-control" placeholder="New Password Again">
            <span class="glyphicon glyphicon-lock form-control-feedback"></span>
        </div>
        <div class="row">
            <div class="col-xs-6">
              <label class="margin-t-5"><a href="{{ route('account.login') }}"><i class="fa fa-chevron-left margin-r-5"></i> Login Page</a></label>
            </div>
            <!-- /.col -->
            <div class="col-xs-6">
              <button type="submit" class="btn btn-primary btn-block btn-flat">Change Password</button>
            </div>
            <!-- /.col -->
        </div>
    </form>

    @include('admin.auth.layouts.footer')

</div>
<!-- END Login Container -->
@stop