@extends('admin.auth.layouts.master')

@section('content')

    @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Warning !</strong> Messages : <br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (Session::has('status'))
        <div class="alert alert-success">
            <p>{{{ Session::get('status') }}}</p>
        </div>
    @endif

    <form action="{{ route('account.forgot.password.form') }}" method="post">
      <div class="form-group has-feedback">
        <input type="text" name="email" class="form-control" placeholder="Email">
        <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
      </div>
      <div class="row">
        <div class="col-xs-7">
          <label class="margin-t-5"><a href="{{ route('account.login') }}"><i class="fa fa-chevron-left margin-r-5"></i> Return To Login Page</a></label>
        </div>
        <!-- /.col -->
        <div class="col-xs-5">
          <button type="submit" name="login" class="btn btn-primary btn-block btn-flat reset-password">Reset Password</button>
        </div>
        <!-- /.col -->
      </div>
    </form>

    @include('admin.auth.layouts.footer')

</div>
<!-- END Login Container -->
@stop