@extends('admin.layouts.master')

@section('styles')
@stop

@section('title') Edit Administrator @stop

@section('metas')
@stop

@section('content')
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>Edit Administrator</h1>
          <ol class="breadcrumb">
            <li><a href="{{ route('dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="{{ route('administrators') }}">Administrators</a></li>
            <li class="active">{{ $administrator->username }}</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
          <div class="row">
            <!-- right column -->
            <div class="col-md-12">
              <!-- Horizontal Form -->
              <div class="box">
                <!-- form start -->
                <form action="{{ route('ajax.update.administrator', [$administrator->id]) }}" name="add" enctype="multipart/form-data" class="form-horizontal form-bordered">
                  <div class="box-body">
                    <!-- Username -->
                    <div class="form-group">
                      <label for="username" class="col-sm-2 control-label">Username</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" name="username" placeholder="Enter the username..." value="{{ $administrator->username }}">
                      </div>
                    </div>

                    <!-- E-Mail -->
                    <div class="form-group">
                      <label for="email" class="col-sm-2 control-label">E-Mail</label>
                      <div class="col-sm-10">
                        <input type="email" class="form-control" name="email" placeholder="Enter the e-mail address..." value="{{ $administrator->email }}">
                      </div>
                    </div>

                    <!-- Password -->
                    <div class="form-group">
                      <label for="password" class="col-sm-2 control-label">Password</label>
                      <div class="col-sm-10">
                        <input type="password" class="form-control" name="password" placeholder="Enter the password...">
                      </div>
                    </div>

                    <!-- Password Again -->
                    <div class="form-group">
                      <label for="password_confirmation" class="col-sm-2 control-label">Password Again</label>
                      <div class="col-sm-10">
                        <input type="password" class="form-control" name="password_confirmation" placeholder="Enter the password...">
                      </div>
                    </div>

                    <!-- Status -->
                    <div class="form-group">
                      <label for="status" class="col-sm-2 control-label">Status</label>
                      <div class="col-sm-10">
                        <input type="checkbox" name="status" class="switch" data-off-text="Passive" data-on-text="Active" data-off-color="warning" data-on-color="success" data-size="small" @if ($administrator->status == 1) checked @endif>
                      </div>
                    </div>

                    <div class="form-group form-actions">
                      <div class="col-sm-10 col-sm-offset-2">
                        <button type="submit" id="update" class="btn btn-info">UPDATE</button>
                      </div>
                    </div>

                  </div><!-- /.box-body -->

                </form>
              </div><!-- /.box -->

            </div><!--/.col (right) -->
          </div>   <!-- /.row -->
        </section><!-- /.content -->
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('admin-assets/dist/js/administrator.js') }}"></script>
@stop