@extends('layouts.master')

@section('metas')
    <title>Not Found</title>
    <meta name="robots" content="noindex, nofollow" />
@stop


@section('content')

    <div class="container">
        <ol class="breadcrumb">
            <li itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a href="{{ route('index') }}" itemprop="url"><span itemprop="title">@language('home')</span></a></li>
            <li class="active">{{ Str::title($title) }}</li>
        </ol>
    </div>

    <!-- Start Content -->
    <div class="container content">

        <div class="problem">

            <div class="problem-img">
                <img src="{{ asset('img/indexicon3.png') }}" alt="icon">
            </div>
            <h1>{{ $title }}</h1>
            <p class="message">{{ $message }}</p>
            @if(isset($form))
                <form action="{{ URL::route('ajax.search') }}" id="general-search-form" class="searchform">
                    <input type="text" name="url" id="url" class="form-control searchinput" @if(isset($site)) value="{{{ $site }}}" @endif  placeholder="@language('enter_website_address')">
                    <button type="submit" id="search-button" class="btn btn-primary searchbutton">@language('analyze_button')</button>
                </form>
            @endif
        </div>


    </div>
    <!-- End Content -->

@stop