<?php


Route::get('test', function(){
    $ip = gethostbyname('canakkaletravel.com');
    return $ip;
});

// INSTALL
Route::group(array('prefix' => 'install'), function () {

    Route::get('/', [
        'as'   => 'install',
        'uses' => 'InstallController@install'
    ]);

    Route::post('install-process', [
        'as'   => 'install-process',
        'uses' => 'InstallController@installProcess'
    ]);

});

// FRONT END
Route::group(array('before' => 'language'), function(){

        Route::get('/', [
            'as'   => 'index',
            'uses' => 'SiteController@home'
        ]);

        Route::get('site/{name}', [
            'as'   => 'site.name',
            'uses' => 'SearchController@index'
        ]);

        Route::get('country/{slug}', [
            'as'   => 'site.country-websites',
            'uses' => 'CountryController@websites'
        ]);

        Route::get('country/{slug}/{page}', [
            'as'   => 'site.country-websites-p',
            'uses' => 'CountryController@websites'
        ]);

        Route::group(array('prefix' => 'ajax'), function () {
            Route::post('search', [
                'as'   => 'ajax.search',
                'uses' => 'AjaxSearchController@search'
            ]);

            Route::post('re-analyze', [
                'as'   => 'ajax.re-analyze',
                'uses' => 'AjaxSearchController@reAnalyze'
            ]);

            Route::post('autocomplete', [
                'as'   => 'ajax.autocomplete',
                'uses' => 'AjaxSearchController@autoCompleteSearch'
            ]);

            Route::post('contact', [
                'as'   => 'ajax.contact',
                'uses' => 'AjaxSiteController@contact'
            ]);

            Route::post('report', [
                'as'   => 'ajax.report',
                'uses' => 'AjaxSiteController@report'
            ]);

            Route::post('new-comment', [
                'as'   => 'ajax.new-comment',
                'uses' => 'AjaxSiteController@newComment'
            ]);

            Route::post('remove-site', [
                'as'   => 'ajax.remove-site',
                'uses' => 'AjaxRemoveController@removeWebSite'
            ]);

            Route::post('verify-website/{slug}', [
                'as'   => 'ajax.verify-website',
                'uses' => 'AjaxRemoveController@verifyWebSite'
            ]);
        });

        Route::group(array('prefix' => 'api'), function () {

            Route::get('sites/{name}', [
                'as'   => 'ajax.autocomplete',
                'uses' => 'AjaxSearchController@autoCompleteSearch'
            ]);

        });

        Route::post('analyze/{type}/{hash}', [
            'as'   => 'analyze.general',
            'uses' => 'AjaxDataController@analyze'
        ]);


        Route::get('site/add/{slug}', [
            'as'   => 'site.add',
            'uses' => 'SiteController@add'
        ]);

        Route::get('site/remove/{slug}', [
            'as'   => 'site.remove',
            'uses' => 'RemoveController@remove'
        ]);

        Route::get('site/download-verification-file/{slug}', [
            'as'   => 'site.download-verification-file',
            'uses' => 'RemoveController@downloadVerificationFile'
        ]);

        Route::get('site/initialize/{hash}', [
            'as' => 'site.initialize',
            'uses' => 'SearchController@initialize'
        ]);

        Route::get('contact', [
            'as'   => 'site.contact',
            'uses' => 'SiteController@contact'
        ]);

        Route::get('report/{id}', [
            'as'   => 'site.report',
            'uses' => 'SiteController@report'
        ]);

        Route::get('country', [
            'as'   => 'site.country',
            'uses' => 'CountryController@index'
        ]);

        Route::get('{slug}.html', [
            'as'   => 'site.page',
            'uses' => 'SiteController@page'
        ]);

        Route::get('css/style.css', [
            'as'   => 'site.css',
            'uses' => 'SiteController@css'
        ]);


        Route::get('webstats-sitemap.xml', [
            'as'   => 'sitemap.index',
            'uses' => 'SiteMapController@index'
        ]);

        Route::get('sitemap-main.xml', [
            'as'   => 'sitemap.main',
            'uses' => 'SiteMapController@main'
        ]);

        Route::get('sitemap-{limit}.xml', [
            'as'   => 'sitemap.websites',
            'uses' => 'SiteMapController@websites'
        ]);


        Route::get('ajax/data/{slug}', [
            'as'   => 'modal.content',
            'uses' => 'SiteController@getContent'
        ]);

        Route::get('change-language/{lang}', [
            'as'   => 'change-language',
            'uses' => 'SiteController@changeLanguage'
        ]);

        Route::get('favicon/{slug}', [
            'as'   => 'favicon',
            'uses' => 'SiteController@getFavicon'
        ]);


        Route::get('404', function(){
            return View::make('404');
        });

    });

// ADMIN
Route::group(array('prefix' => 'admin'), function () {

    Route::group(array('before' => 'redirect.auth'), function () {
        // Login - Logout - I forgot my password
        Route::get('', [
            'as'   => 'account.login',
            'uses' => 'AuthController@getLogin'
        ]);

        Route::post('login', [
            'as'   => 'account.login.form',
            'uses' => 'AuthController@postLogin'
        ]);

        Route::get('password/forgot', [
            'as'   => 'account.forgot.password',
            'uses' => 'AuthController@getForgotPassword'
        ]);

        Route::post('password/forgot', [
            'as'   => 'account.forgot.password.form',
            'uses' => 'AuthController@postForgotPassword'
        ]);

        Route::get('password/reset/{token}', [
            'as'   => 'account.password.reset',
            'uses' => 'AuthController@getResetPassword'
        ]);

        Route::post('password/reset', [
            'as'   => 'account.password.reset.form',
            'uses' => 'AuthController@postResetPassword'
        ]);

        Route::get('logout', [
            'as'   => 'account.logout',
            'uses' => 'AuthController@getLogout'
        ]);
    });

    Route::group(array('before' => 'auth'), function () {

        Route::get('dashboard', [
            'as'       => 'dashboard',
            'uses'     => 'DashboardController@index'
        ]);

        /* Page */
        Route::group(array('prefix' => 'page'), function () {
            Route::get('all', [
                'as'       => 'pages',
                'uses'     => 'PageController@all'
            ]);

            Route::get('add', [
                'as'       => 'page.add',
                'uses'     => 'PageController@add'
            ]);

            Route::get('edit/{id}', [
                'as'       => 'page.edit',
                'uses'     => 'PageController@edit'
            ]);

            /* Ajax Page */
            Route::group(array('prefix' => 'ajax'), function () {
                Route::get('get', [
                    'as'   => 'ajax.get.pages',
                    'uses' => 'PageControllerAjax@get'
                ]);

                Route::post('create', [
                    'as'       => 'ajax.create.page',
                    'uses'     => 'PageControllerAjax@create'
                ]);

                Route::post('update/{id}', [
                    'as'       => 'ajax.update.page',
                    'uses'     => 'PageControllerAjax@update'
                ]);

                Route::post('remove/{id}', [
                    'as'       => 'ajax.remove.page',
                    'uses'     => 'PageControllerAjax@remove'
                ]);
            });
        });

        /* Administrator */
        Route::group(array('prefix' => 'administrator'), function () {
            Route::get('all', [
                'as'       => 'administrators',
                'uses'     => 'AdministratorController@all'
            ]);

            Route::get('add', [
                'as'       => 'administrator.add',
                'uses'     => 'AdministratorController@add'
            ]);

            Route::get('edit/{id}', [
                'as'       => 'administrator.edit',
                'uses'     => 'AdministratorController@edit'
            ]);

            /* Ajax Administrator */
            Route::group(array('prefix' => 'ajax'), function () {
                Route::get('get', [
                    'as'   => 'ajax.get.administrators',
                    'uses' => 'AdministratorControllerAjax@get'
                ]);

                Route::post('create', [
                    'as'       => 'ajax.create.administrator',
                    'uses'     => 'AdministratorControllerAjax@create'
                ]);

                Route::post('update/{id}', [
                    'as'       => 'ajax.update.administrator',
                    'uses'     => 'AdministratorControllerAjax@update'
                ]);

                Route::post('remove/{id}', [
                    'as'       => 'ajax.remove.administrator',
                    'uses'     => 'AdministratorControllerAjax@remove'
                ]);
            });
        });

        /* Word Filter */
        Route::group(array('prefix' => 'word-filter'), function () {
            Route::get('/', [
                'as'       => 'word.filter.all',
                'uses'     => 'WordFilterController@all'
            ]);

            Route::get('add', [
                'as'       => 'word.filter.add',
                'uses'     => 'WordFilterController@add'
            ]);

            /* Ajax Word Filter */
            Route::group(array('prefix' => 'ajax'), function () {
                Route::get('get', [
                    'as'   => 'ajax.get.filter.words',
                    'uses' => 'WordFilterControllerAjax@get'
                ]);

                Route::post('create', [
                    'as'       => 'ajax.create.filter.word',
                    'uses'     => 'WordFilterControllerAjax@create'
                ]);

                Route::post('remove/{id}', [
                    'as'       => 'ajax.remove.filter.word',
                    'uses'     => 'WordFilterControllerAjax@remove'
                ]);
            });
        });

        /* Website */
        Route::group(array('prefix' => 'website'), function () {
            Route::get('all', [
                'as'       => 'website.list',
                'uses'     => 'WebsiteController@all'
            ]);

            Route::get('edit/{id}', [
                'as'       => 'website-edit',
                'uses'     => 'WebsiteController@edit'
            ]);

            Route::get('deletion-requests', [
                'as'       => 'deletion-requests',
                'uses'     => 'WebsiteController@deletion'
            ]);

            Route::get('bulk-upload', [
                'as'       => 'bulk.upload',
                'uses'     => 'WebsiteController@bulkUpload'
            ]);

            /* Ajax Website */
            Route::group(array('prefix' => 'ajax'), function () {
                Route::get('get', [
                    'as'   => 'ajax.get.website',
                    'uses' => 'WebsiteControllerAjax@get'
                ]);

                Route::get('deletion-requests', [
                    'as'   => 'ajax.get.deletion',
                    'uses' => 'WebsiteControllerAjax@deletionRequests'
                ]);

                Route::post('bulk-website-create', [
                    'as'       => 'ajax.bulk.website.create',
                    'uses'     => 'WebsiteControllerAjax@bulkWebsiteCreate'
                ]);

                Route::post('update/{id}', [
                    'as'       => 'ajax.update.website',
                    'uses'     => 'WebsiteControllerAjax@update'
                ]);

                Route::post('remove/{id}', [
                    'as'       => 'ajax.remove.website',
                    'uses'     => 'WebsiteControllerAjax@remove'
                ]);

                Route::post('remove-screenshot({ss}', [
                    'as'       => 'ajax.remove.website.screenshot',
                    'uses'     => 'WebsiteControllerAjax@removeScreenshot'
                ]);
            });
        });

        /* Contact */
        Route::group(array('prefix' => 'contacts'), function () {
            Route::get('/', [
                'as'       => 'contacts',
                'uses'     => 'ContactController@all'
            ]);

            Route::get('show/{id}', [
                'as'       => 'contact-show',
                'uses'     => 'ContactController@show'
            ]);

            /* Ajax Contact */
            Route::group(array('prefix' => 'ajax'), function () {
                Route::get('get', [
                    'as'   => 'ajax.get.contacts',
                    'uses' => 'ContactControllerAjax@get'
                ]);

                Route::post('remove/{id}', [
                    'as'       => 'ajax.remove.contact',
                    'uses'     => 'ContactControllerAjax@remove'
                ]);
            });
        });

        /* Report */
        Route::group(array('prefix' => 'reports'), function () {
            Route::get('/', [
                'as'       => 'reports',
                'uses'     => 'ReportController@all'
            ]);

            Route::get('show/{id}', [
                'as'       => 'report.show',
                'uses'     => 'ReportController@show'
            ]);

            /* Ajax Report */
            Route::group(array('prefix' => 'ajax'), function () {
                Route::get('get', [
                    'as'   => 'ajax.get.reports',
                    'uses' => 'ReportControllerAjax@get'
                ]);

                Route::post('remove/{id}', [
                    'as'       => 'ajax.remove.report',
                    'uses'     => 'ReportControllerAjax@remove'
                ]);
            });
        });

        /* Comment */
        Route::group(array('prefix' => 'comments'), function () {
            Route::get('/', [
                'as'       => 'comments',
                'uses'     => 'CommentController@all'
            ]);

            Route::get('edit/{id}', [
                'as'       => 'comment-edit',
                'uses'     => 'CommentController@edit'
            ]);

            /* Ajax Comment */
            Route::group(array('prefix' => 'ajax'), function () {
                Route::get('get', [
                    'as'   => 'ajax.get.comments',
                    'uses' => 'CommentControllerAjax@get'
                ]);

                Route::post('update/{id}', [
                    'as'       => 'ajax.update.comment',
                    'uses'     => 'CommentControllerAjax@update'
                ]);

                Route::post('remove/{id}', [
                    'as'       => 'ajax.remove.comment',
                    'uses'     => 'CommentControllerAjax@remove'
                ]);
            });
        });

        /* Settings */
        Route::group(array('prefix' => 'settings'), function () {
            /* General */
            Route::group(array('prefix' => 'general'), function () {
                Route::get('/', [
                    'as'       => 'general.settings',
                    'uses'     => 'SettingController@general'
                ]);

                /* Ajax General */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('update/{id}', [
                        'as'       => 'ajax.update.general.settings',
                        'uses'     => 'SettingControllerAjax@generalUpdate'
                    ]);
                });
            });

            /* Social Media */
            Route::group(array('prefix' => 'social-media'), function () {
                Route::get('/', [
                    'as'       => 'social.media.settings',
                    'uses'     => 'SettingController@socialMedia'
                ]);

                /* Ajax Social Media  */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('update/{id}', [
                        'as'       => 'ajax.update.social.settings',
                        'uses'     => 'SettingControllerAjax@socialUpdate'
                    ]);
                });
            });

            /* Api Keys */
            Route::group(array('prefix' => 'api-keys'), function () {
                Route::get('/', [
                    'as'       => 'api.key.settings',
                    'uses'     => 'SettingController@apiKeys'
                ]);

                /* Ajax Social Media */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('update/{id}', [
                        'as'       => 'ajax.update.api.key.settings',
                        'uses'     => 'SettingControllerAjax@apiKeysUpdate'
                    ]);
                });
            });

            /* Mail */
            Route::group(array('prefix' => 'mail'), function () {
                Route::get('/', [
                    'as'       => 'mail.settings',
                    'uses'     => 'SettingController@mail'
                ]);

                /* Ajax Mail */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('update/{id}', [
                        'as'       => 'ajax.update.mail.settings',
                        'uses'     => 'SettingControllerAjax@mailUpdate'
                    ]);
                });
            });

            /* Sitemap */
            Route::group(array('prefix' => 'sitemap'), function () {
                Route::get('/', [
                    'as'       => 'sitemap.settings',
                    'uses'     => 'SettingController@sitemap'
                ]);

                /* Ajax Sitemap */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('update/{id}', [
                        'as'       => 'ajax.update.sitemap.settings',
                        'uses'     => 'SettingControllerAjax@sitemapUpdate'
                    ]);
                });
            });

            /* Comment */
            Route::group(array('prefix' => 'comment'), function () {
                Route::get('/', [
                    'as'       => 'comment.settings',
                    'uses'     => 'SettingController@comment'
                ]);

                /* Ajax Comment */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('update/{id}', [
                        'as'       => 'ajax.update.comment.settings',
                        'uses'     => 'SettingControllerAjax@commentUpdate'
                    ]);
                });
            });

            /* Pagination */
            Route::group(array('prefix' => 'pagination'), function () {
                Route::get('/', [
                    'as'       => 'pagination.settings',
                    'uses'     => 'SettingController@pagination'
                ]);

                /* Ajax Pagination */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('update/{id}', [
                        'as'       => 'ajax.update.pagination.settings',
                        'uses'     => 'SettingControllerAjax@paginationUpdate'
                    ]);
                });
            });

            /* Layout */
            Route::group(array('prefix' => 'layout'), function () {
                Route::get('/', [
                    'as'       => 'layout.settings',
                    'uses'     => 'SettingController@layout'
                ]);

                /* Ajax Layout */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('update/{id}', [
                        'as'       => 'ajax.update.layout.settings',
                        'uses'     => 'SettingControllerAjax@layoutUpdate'
                    ]);
                });
            });

            /* Cache */
            Route::group(array('prefix' => 'cache'), function () {
                Route::get('/', [
                    'as'       => 'cache.settings',
                    'uses'     => 'SettingController@cache'
                ]);

                /* Ajax Cache */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('update/{id}', [
                        'as'       => 'ajax.update.cache.settings',
                        'uses'     => 'SettingControllerAjax@cacheUpdate'
                    ]);
                });

                /* Ajax Clear All Cache */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('clear', [
                        'as'       => 'ajax.clear.all.cache',
                        'uses'     => 'SettingControllerAjax@clearAllCache'
                    ]);
                });
            });

            /* Ads */
            Route::group(array('prefix' => 'ads'), function () {
                Route::get('/', [
                    'as'       => 'ads.settings',
                    'uses'     => 'SettingController@ads'
                ]);

                /* Ajax Cache */
                Route::group(array('prefix' => 'ajax'), function () {
                    Route::post('update/{id}', [
                        'as'       => 'ajax.update.ads.settings',
                        'uses'     => 'SettingControllerAjax@adsUpdate'
                    ]);
                });
            });

        });

        Route::post('ajax/image-upload', [
            'as'       => 'image.upload',
            'uses'     => 'UploadControllerAjax@imageUpload'
        ]);

        Route::post('ajax/file-upload', [
            'as'       => 'file.upload',
            'uses'     => 'UploadControllerAjax@fileUpload'
        ]);

        /* Language */
        Route::group(array('prefix' => 'languages'), function () {
            Route::get('/', [
                'as'       => 'languages',
                'uses'     => 'LanguageController@all'
            ]);

            Route::get('add', [
                'as'       => 'language.add',
                'uses'     => 'LanguageController@add'
            ]);

            Route::get('edit/{id}', [
                'as'       => 'language.edit',
                'uses'     => 'LanguageController@edit'
            ]);

            /* Ajax Comment */
            Route::group(array('prefix' => 'ajax'), function () {
                Route::get('get', [
                    'as'   => 'ajax.get.languages',
                    'uses' => 'LanguageControllerAjax@get'
                ]);

                Route::post('create', [
                    'as'       => 'ajax.create.language',
                    'uses'     => 'LanguageControllerAjax@create'
                ]);

                Route::post('update/{id}', [
                    'as'       => 'ajax.update.language',
                    'uses'     => 'LanguageControllerAjax@update'
                ]);

                Route::post('remove/{id}', [
                    'as'       => 'ajax.remove.language',
                    'uses'     => 'LanguageControllerAjax@remove'
                ]);
            });
        });

        /* Statistics */
        Route::group(array('prefix' => 'statistics'), function () {
            Route::get('/', [
                'as'       => 'statistics',
                'uses'     => 'StatisticController@all'
            ]);




        });
    });





});

Route::get('get-the-cron-row/8080', function(){
    return 'php '.base_path('artisan').' cron:run';
});
