<?php
use \Carbon\Carbon;

class WebSiteUnIndexed extends Eloquent
{

    protected $table = 'website_unindexed';
    protected $fillable = array('name');
    public $timestamps = false;

    public static function add($sites, $list_number = 0)
    {
        $temp_arr = [];
        foreach ($sites as $site) {
            $temp_arr[] = [
                'name'         => $site,
                'list_number'  => $list_number,
                'created_date' => Carbon::now()->timestamp
            ];
        }

        $chunkArr = array_chunk($temp_arr, 1000);

        foreach($chunkArr as $part){
            self::insert($part);
        }
    }

    public static function getOne($list_number = 0)
    {
        return self::where('status', 0)->where('list_number', $list_number)->first();
    }

}
